/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.interfaces.IRowCountResult;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResultType;
import com.amazon.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.amazon.sqlengine.dsiext.dataengine.ProcedureParameterValue;
import com.amazon.sqlengine.dsiext.dataengine.StoredProcedure;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.exceptions.SQLEngineRuntimeException;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.value.ETDefaultParameter;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.ETValueExprList;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ETProcedure
extends ETRelationalExpr {
    private final StoredProcedure m_procedure;
    private final List<ProcedureParameterMetadata> m_argsMetadata;
    private final ETValueExprList m_arguments;
    private Iterator<ExecutionResult> m_resultIterator;
    private ExecutionResult m_currentResult;
    private boolean m_isOpen;
    private boolean m_hasReturnValue;

    public ETProcedure(StoredProcedure storedProcedure, List<ProcedureParameterMetadata> list, ETValueExprList eTValueExprList, boolean[] blArray, boolean bl) {
        super(blArray);
        this.m_procedure = storedProcedure;
        this.m_argsMetadata = list;
        this.m_arguments = eTValueExprList;
        this.m_hasReturnValue = bl;
    }

    @Override
    public void close(boolean bl) {
        if (this.m_isOpen) {
            this.m_arguments.close(false);
            if (null != this.m_resultIterator) {
                while (this.m_resultIterator.hasNext()) {
                    ExecutionResult executionResult = this.m_resultIterator.next();
                    switch (executionResult.getType()) {
                        case RESULT_SET: {
                            ((IResultSet)executionResult.getResult()).close();
                            break;
                        }
                        case ROW_COUNT: {
                            ((IRowCountResult)executionResult.getResult()).close();
                            break;
                        }
                    }
                }
            }
            this.m_isOpen = false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() throws ErrorException {
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_procedure.getCurrentResultMetadata().get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_procedure.getCurrentResultMetadata().size();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_currentResult.getRowCount();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        if (!this.m_isOpen) {
            this.m_arguments.open();
            this.execute();
            for (ExecutionResult executionResult : this.m_procedure.getResults().getResults()) {
                if (ExecutionResultType.RESULT_SET != executionResult.getType()) continue;
                ((IResultSet)executionResult.getResult()).setCursorType(cursorType);
            }
            this.m_resultIterator = this.m_procedure.getResults().getResultItr();
            this.moveToNextResult();
            this.m_isOpen = true;
        }
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        eTDataRequest.getData().setValue(dataWrapper);
        if (this.m_currentResult.getType() == ExecutionResultType.RESULT_SET) {
            boolean bl = ((IResultSet)this.m_currentResult.getResult()).getData(n, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), dataWrapper);
            return bl;
        }
        throw SQLEngineExceptionFactory.failedToReadData();
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.m_arguments;
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (ExecutionResultType.RESULT_SET == this.m_currentResult.getType()) {
            ((IResultSet)this.m_currentResult.getResult()).moveToNextRow();
        }
        return false;
    }

    public ExecutionResult getCurrentResult() {
        return this.m_currentResult;
    }

    public StoredProcedure getProcedure() {
        return this.m_procedure;
    }

    private void execute() throws ErrorException {
        ArrayList<ProcedureParameterValue> arrayList = new ArrayList<ProcedureParameterValue>();
        boolean bl = this.m_procedure.hasReturnValue();
        if (!this.m_hasReturnValue && bl) {
            DataWrapper dataWrapper = new DataWrapper();
            arrayList.add(new ProcedureParameterValue(dataWrapper, true));
        } else if (this.m_hasReturnValue && !bl) {
            throw new ErrorException(DiagState.DIAG_INVALID_PARAM_TYPE, 7, SQLEngineMessageKey.INVALID_TYPE_PARAMS.name());
        }
        for (int i = 0; i < this.m_argsMetadata.size(); ++i) {
            ProcedureParameterValue procedureParameterValue;
            ETValueExpr eTValueExpr = (ETValueExpr)this.m_arguments.getChild(i);
            ProcedureParameterMetadata procedureParameterMetadata = this.m_argsMetadata.get(i);
            switch (procedureParameterMetadata.getParameterType()) {
                case OUTPUT: 
                case RETURN_VALUE: {
                    procedureParameterValue = new ProcedureParameterValue(eTValueExpr.getCachedDataWrapper(), false);
                    break;
                }
                case INPUT: 
                case INPUT_OUTPUT: {
                    if (eTValueExpr instanceof ETDefaultParameter) {
                        procedureParameterValue = new ProcedureParameterValue(null, true);
                        break;
                    }
                    ETDataRequest eTDataRequest = new ETDataRequest(procedureParameterMetadata.getEquivalentColumnMeta());
                    eTValueExpr.retrieveData(eTDataRequest);
                    DataWrapper dataWrapper = eTValueExpr.getCachedDataWrapper() == null ? new DataWrapper() : eTValueExpr.getCachedDataWrapper();
                    eTDataRequest.getData().retrieveData(dataWrapper);
                    procedureParameterValue = new ProcedureParameterValue(dataWrapper, false);
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidTypeParameterException("" + procedureParameterMetadata.getParameterType().getIntValue());
                }
            }
            arrayList.add(procedureParameterValue);
        }
        this.m_procedure.execute(arrayList);
    }

    private void moveToNextResult() throws ErrorException {
        if (null == this.m_resultIterator) {
            throw new SQLEngineRuntimeException();
        }
        if (this.m_resultIterator.hasNext()) {
            this.m_currentResult = this.m_resultIterator.next();
        }
    }
}

