/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.Var;

class Slot {
    Value value;
    Var variable;
    Resource resource;
    Property property;
    Literal literal;

    private void unset() {
        this.value = null;
        this.variable = null;
        this.resource = null;
        this.property = null;
        this.literal = null;
    }

    public Slot() {
        this.unset();
    }

    public Slot(Slot slot) {
        this.value = slot.value;
        this.variable = slot.variable;
        this.property = slot.property;
        this.resource = slot.resource;
    }

    public void set(Value v) {
        this.unset();
        this.value = v;
    }

    public void set(Var v) {
        this.unset();
        this.variable = v;
    }

    public void set(Resource r) {
        this.unset();
        this.resource = r;
    }

    public void set(Property p) {
        this.unset();
        this.property = p;
    }

    public void set(Literal l) {
        this.unset();
        this.literal = l;
    }

    public boolean isValue() {
        return this.value != null;
    }

    public boolean isVar() {
        return this.variable != null;
    }

    public boolean isResource() {
        return this.resource != null;
    }

    public boolean isProperty() {
        return this.property != null;
    }

    public boolean isLiteral() {
        return this.literal != null;
    }

    public Value getValue() {
        return this.value;
    }

    public Var getVar() {
        return this.variable;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Property getProperty() {
        return this.property;
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public String getVarName() {
        if (this.variable == null) {
            return null;
        }
        return this.variable.getVarName();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.asInfixString();
        }
        if (this.variable != null) {
            return this.variable.toString();
        }
        if (this.property != null) {
            return "<" + this.property.toString() + ">";
        }
        if (this.resource != null) {
            return "<" + ((Object)this.resource).toString() + ">";
        }
        if (this.literal != null) {
            String s = this.literal.toString();
            if (this.literal.getLanguage().equals("") && this.literal.getDatatype() == null) {
                return s;
            }
            StringBuffer sb = new StringBuffer(s);
            if (!this.literal.getLanguage().equals("")) {
                sb.append("@").append(this.literal.getLanguage());
            }
            if (this.literal.getDatatype() != null) {
                sb.append("^^").append(this.literal.getDatatypeURI());
            }
            return sb.toString();
        }
        return "slot:unset";
    }
}

