/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.integer;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;

public class IntMinusView<I extends IntVar>
extends IntView<I> {
    public IntMinusView(I var) {
        super("-(" + var.getName() + ")", var);
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return -value;
            }
        };
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        boolean hasChanged = false;
        if (olb < lb || oub > ub) {
            IntEventType e = null;
            if (olb < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, this.getLB(), cause);
                e = IntEventType.INCLOW;
                if (this.var.updateUpperBound(-lb, this)) {
                    hasChanged = true;
                } else {
                    this.model.getSolver().getEventObserver().undo();
                }
            }
            if (oub > ub) {
                e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, this.getUB(), cause);
                if (this.var.updateLowerBound(-ub, this)) {
                    hasChanged = true;
                } else {
                    this.model.getSolver().getEventObserver().undo();
                }
            }
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            if (hasChanged) {
                this.notifyPropagators(e, cause);
            }
        }
        return hasChanged;
    }

    @Override
    protected boolean doInstantiateVar(int value) throws ContradictionException {
        return this.var.instantiateTo(-value, this);
    }

    @Override
    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        return this.var.updateUpperBound(-value, this);
    }

    @Override
    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        return this.var.updateLowerBound(-value, this);
    }

    @Override
    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        return this.var.removeValue(-value, this);
    }

    @Override
    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        return this.var.removeInterval(-to, -from, this);
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(-value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(-value);
    }

    @Override
    public int getValue() {
        return -this.var.getValue();
    }

    @Override
    public int getLB() {
        return -this.var.getUB();
    }

    @Override
    public int getUB() {
        return -this.var.getLB();
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.previousValue(-v);
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -value;
    }

    @Override
    public int nextValueOut(int v) {
        return -this.var.previousValueOut(-v);
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.nextValue(-v);
        if (value == Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return -value;
    }

    @Override
    public int previousValueOut(int v) {
        return -this.var.nextValueOut(-v);
    }

    protected EvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return "-(" + this.var.toString() + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = IntMinusView.this.var.getValueIterator(false);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = IntMinusView.this.var.getValueIterator(true);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasNext();
                }

                @Override
                public int next() {
                    return -this.vit.previous();
                }

                @Override
                public int previous() {
                    return -this.vit.next();
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableRangeIterator vir;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vir = IntMinusView.this.var.getRangeIterator(false);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vir = IntMinusView.this.var.getRangeIterator(true);
                }

                @Override
                public boolean hasNext() {
                    return this.vir.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vir.hasNext();
                }

                @Override
                public void next() {
                    this.vir.previous();
                }

                @Override
                public void previous() {
                    this.vir.next();
                }

                @Override
                public int min() {
                    return -this.vir.max();
                }

                @Override
                public int max() {
                    return -this.vir.min();
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vir.dispose();
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public IEventType transformEvent(IEventType evt) {
        if (evt == IntEventType.INCLOW) {
            return IntEventType.DECUPP;
        }
        if (evt == IntEventType.DECUPP) {
            return IntEventType.INCLOW;
        }
        return evt;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        switch (mask) {
            case DECUPP: {
                this.model.getSolver().getEventObserver().updateLowerBound(this, -one, -two, this);
                break;
            }
            case INCLOW: {
                this.model.getSolver().getEventObserver().updateUpperBound(this, -one, -two, this);
                break;
            }
            case REMOVE: {
                this.model.getSolver().getEventObserver().removeValue(this, -one, this);
                break;
            }
            case INSTANTIATE: {
                this.model.getSolver().getEventObserver().instantiateTo(this, -one, this, -three, -two);
            }
        }
    }
}

