/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeIntervals
implements IntervalList {
    private int[] indices;
    private int[] storedIndices;
    private double[] times;
    private double[] storedTimes;
    private Tree tree = null;
    private double[] intervals;
    private double[] storedIntervals;
    private int[] lineageCounts;
    private int[] storedLineageCounts;
    private List<NodeRef>[] lineagesAdded;
    private List<NodeRef>[] lineagesRemoved;
    private List[] lineages;
    private int intervalCount = 0;
    private boolean intervalsKnown = false;
    private boolean storedIntervalsKnown;
    private double multifurcationLimit = -1.0;
    private static final boolean superStore = true;

    public TreeIntervals() {
    }

    public TreeIntervals(Tree tree) {
        this.setTree(tree);
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.intervalsKnown = false;
    }

    public void setIntervalsUnknown() {
        this.intervalsKnown = false;
    }

    public void setMultifurcationLimit(double d) {
        this.multifurcationLimit = d;
        this.intervalsKnown = false;
    }

    @Override
    public int getSampleCount() {
        return this.tree.getExternalNodeCount();
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    @Override
    public double getInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.intervals[n];
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.lineageCounts[n];
    }

    public final List getLineages(int n) {
        if (this.lineages[n] == null) {
            ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
            for (int i = 0; i <= n; ++i) {
                if (this.lineagesAdded[i] != null) {
                    arrayList.addAll(this.lineagesAdded[i]);
                }
                if (this.lineagesRemoved[i] == null) continue;
                arrayList.removeAll(this.lineagesRemoved[i]);
            }
            this.lineages[n] = Collections.unmodifiableList(arrayList);
        }
        return this.lineages[n];
    }

    @Override
    public int getCoalescentEvents(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        if (n < this.intervalCount - 1) {
            return this.lineageCounts[n] - this.lineageCounts[n + 1];
        }
        return this.lineageCounts[n] - 1;
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getCoalescentEvents(n);
        if (n2 > 0) {
            return IntervalType.COALESCENT;
        }
        if (n2 < 0) {
            return IntervalType.SAMPLE;
        }
        return IntervalType.NOTHING;
    }

    public NodeRef getCoalescentNode(int n) {
        if (this.getIntervalType(n) == IntervalType.COALESCENT) {
            if (this.lineagesRemoved[n] != null) {
                if (this.lineagesAdded[n].size() == 1) {
                    return this.lineagesAdded[n].get(0);
                }
                throw new IllegalArgumentException("multiple lineages lost over this interval!");
            }
            throw new IllegalArgumentException("Inconsistent: no lineages lost over this interval!");
        }
        throw new IllegalArgumentException("Interval " + n + " is not a coalescent interval.");
    }

    @Override
    public double getTotalDuration() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        double d = 0.0;
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.intervals[i];
        }
        return d;
    }

    @Override
    public boolean isBinaryCoalescent() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) <= 0 || this.getCoalescentEvents(i) == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCoalescentOnly() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) >= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void calculateIntervals() {
        int n = this.tree.getNodeCount();
        this.times = new double[n];
        int[] nArray = new int[n];
        TreeIntervals.collectTimes(this.tree, this.times, nArray);
        this.indices = new int[n];
        HeapSort.sort(this.times, this.indices);
        if (this.intervals == null || this.intervals.length != n) {
            this.intervals = new double[n];
            this.lineageCounts = new int[n];
            this.lineagesAdded = new List[n];
            this.lineagesRemoved = new List[n];
            this.lineages = new List[n];
        }
        double d = this.times[this.indices[0]];
        int n2 = 0;
        int n3 = 0;
        this.intervalCount = 0;
        while (n3 < n) {
            double d2;
            int n4 = 0;
            int n5 = 0;
            double d3 = this.times[this.indices[n3]];
            do {
                int n6 = this.indices[n3];
                int n7 = nArray[n6];
                ++n3;
                if (n7 == 0) {
                    this.addLineage(this.intervalCount, this.tree.getNode(n6));
                    ++n5;
                    continue;
                }
                n4 += n7 - 1;
                NodeRef nodeRef = this.tree.getNode(n6);
                for (int i = 0; i < n7; ++i) {
                    NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
                    this.removeLineage(this.intervalCount, nodeRef2);
                }
                this.addLineage(this.intervalCount, nodeRef);
                if (this.multifurcationLimit == 0.0) break;
            } while (n3 < n && Math.abs((d2 = this.times[this.indices[n3]]) - d3) <= this.multifurcationLimit);
            if (n5 > 0) {
                if (this.intervalCount > 0 || d3 - d > this.multifurcationLimit) {
                    this.intervals[this.intervalCount] = d3 - d;
                    this.lineageCounts[this.intervalCount] = n2;
                    ++this.intervalCount;
                }
                d = d3;
            }
            n2 += n5;
            if (n4 > 0) {
                this.intervals[this.intervalCount] = d3 - d;
                this.lineageCounts[this.intervalCount] = n2;
                ++this.intervalCount;
                d = d3;
            }
            n2 -= n4;
        }
        this.intervalsKnown = true;
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.times[this.indices[n]];
    }

    private void addLineage(int n, NodeRef nodeRef) {
        if (this.lineagesAdded[n] == null) {
            this.lineagesAdded[n] = new ArrayList<NodeRef>();
        }
        this.lineagesAdded[n].add(nodeRef);
    }

    private void removeLineage(int n, NodeRef nodeRef) {
        if (this.lineagesRemoved[n] == null) {
            this.lineagesRemoved[n] = new ArrayList<NodeRef>();
        }
        this.lineagesRemoved[n].add(nodeRef);
    }

    public double getDelta() {
        return IntervalList.Utils.getDelta(this);
    }

    private static void collectTimes(Tree tree, double[] dArray, int[] nArray) {
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            NodeRef nodeRef = tree.getNode(i);
            dArray[i] = tree.getNodeHeight(nodeRef);
            nArray[i] = tree.getChildCount(nodeRef);
        }
    }

    @Override
    public final Units.Type getUnits() {
        return this.tree.getUnits();
    }

    @Override
    public final void setUnits(Units.Type type) {
        throw new IllegalArgumentException("Can't set interval's units");
    }

    public void storeState() {
        if (this.intervalsKnown) {
            if (this.storedIntervals == null) {
                this.storedIntervals = new double[this.intervals.length];
            }
            if (this.storedLineageCounts == null) {
                this.storedLineageCounts = new int[this.lineageCounts.length];
            }
            if (this.storedIndices == null) {
                this.storedIndices = new int[this.indices.length];
            }
            if (this.storedTimes == null) {
                this.storedTimes = new double[this.times.length];
            }
            System.arraycopy(this.intervals, 0, this.storedIntervals, 0, this.intervals.length);
            System.arraycopy(this.lineageCounts, 0, this.storedLineageCounts, 0, this.lineageCounts.length);
            System.arraycopy(this.indices, 0, this.storedIndices, 0, this.indices.length);
            System.arraycopy(this.times, 0, this.storedTimes, 0, this.times.length);
        }
        this.storedIntervalsKnown = this.intervalsKnown;
    }

    public void restoreState() {
        this.intervalsKnown = this.storedIntervalsKnown;
        if (this.intervalsKnown) {
            double[] dArray = this.storedIntervals;
            this.storedIntervals = this.intervals;
            this.intervals = dArray;
            int[] nArray = this.storedLineageCounts;
            this.storedLineageCounts = this.lineageCounts;
            this.lineageCounts = nArray;
            dArray = this.storedTimes;
            this.storedTimes = this.times;
            this.times = dArray;
            nArray = this.storedIndices;
            this.storedIndices = this.indices;
            this.indices = nArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getIntervalCount(); ++i) {
            stringBuilder.append("[ ");
            stringBuilder.append(this.getInterval(i));
            stringBuilder.append(": ");
            stringBuilder.append(this.getIntervalTime(i));
            stringBuilder.append(": ");
            stringBuilder.append(this.getLineageCount(i));
            stringBuilder.append(" ]");
        }
        return stringBuilder.toString();
    }
}

