/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;
import uk.ac.rhul.cs.cl1.ClusterONE;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.ui.ClusterONEAlgorithmParametersPanel;
import uk.ac.rhul.cs.cl1.ui.CollapsiblePanel;
import uk.ac.rhul.cs.cl1.ui.EmptyIcon;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CloseControlPanelAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.HelpAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.SelectionPropertiesPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.StartAction;

public class ControlPanel
extends JPanel
implements CytoPanelComponent,
PropertyChangeListener,
SetCurrentNetworkListener,
NetworkAddedListener,
NetworkDestroyedListener {
    protected ClusterONEAlgorithmParametersPanel algorithmParametersPanel;
    protected SelectionPropertiesPanel selectionInfoPanel;
    protected JComboBox weightAttributeCombo;
    protected JButton weightAttributeRefreshButton;
    protected ClusterONECytoscapeApp app;

    public ControlPanel(ClusterONECytoscapeApp app) {
        this.app = app;
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel algorithmParametersPanel = this.constructAlgorithmParametersPanel();
        Dimension d = algorithmParametersPanel.getPreferredSize();
        d.width = Integer.MAX_VALUE;
        algorithmParametersPanel.setMaximumSize(d);
        this.add(algorithmParametersPanel);
        this.add(this.constructSelectionInfoPanel());
        this.add(this.constructButtonPanel());
        this.add(Box.createVerticalGlue());
        this.updateCollapsiblePanelIcons();
    }

    protected JPanel constructAlgorithmParametersPanel() {
        URL url = this.app.getResource(this.app.getResourcePathName() + "/refresh.png");
        this.algorithmParametersPanel = new ClusterONEAlgorithmParametersPanel();
        JPanel weightPanel = new JPanel();
        weightPanel.setLayout(new FlowLayout(0, 0, 0));
        this.weightAttributeCombo = new JComboBox();
        this.updateWeightAttributeCombo();
        this.weightAttributeRefreshButton = new JButton(url == null ? new EmptyIcon() : new ImageIcon(url));
        this.weightAttributeRefreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ControlPanel.this.updateWeightAttributeCombo();
            }
        });
        if (ClusterONE.isRunningOnMac()) {
            this.weightAttributeRefreshButton.putClientProperty("JButton.buttonType", "square");
        }
        weightPanel.add(this.weightAttributeCombo);
        weightPanel.add(Box.createHorizontalStrut(3));
        weightPanel.add(this.weightAttributeRefreshButton);
        this.algorithmParametersPanel.addComponent(ClusterONEAlgorithmParametersPanel.Section.BASIC, "Edge weights:", weightPanel);
        try {
            this.algorithmParametersPanel.monitorComponent(this.weightAttributeCombo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.algorithmParametersPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.algorithmParametersPanel.addPropertyChangeListener("parameters", this);
        return this.algorithmParametersPanel;
    }

    protected JPanel constructSelectionInfoPanel() {
        this.selectionInfoPanel = new SelectionPropertiesPanel(this);
        return new CollapsiblePanel(this.selectionInfoPanel, "Selection info");
    }

    protected JPanel constructButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton startButton = new JButton("Start");
        startButton.addActionListener((ActionListener)((Object)new StartAction(this.app)));
        buttonPanel.add(startButton);
        JButton closeButton = new JButton("Close panel");
        closeButton.addActionListener((ActionListener)((Object)new CloseControlPanelAction(this)));
        buttonPanel.add(closeButton);
        JButton helpButton = new JButton((Action)((Object)new HelpAction(this.app, "control-panel")));
        if (ClusterONE.isRunningOnMac()) {
            helpButton.putClientProperty("JButton.buttonType", "help");
            helpButton.setText("");
        }
        buttonPanel.add(helpButton);
        return buttonPanel;
    }

    ClusterONEAlgorithmParameters getParameters() {
        return this.algorithmParametersPanel.getParameters();
    }

    public static ControlPanel getShownInstance(CySwingApplication app) {
        CytoPanel panel = app.getCytoPanel(CytoPanelName.WEST);
        for (int i = 0; i < panel.getCytoPanelComponentCount(); ++i) {
            Component c = panel.getComponentAt(i);
            if (!(c instanceof ControlPanel)) continue;
            return (ControlPanel)c;
        }
        return null;
    }

    public String getWeightAttributeName() {
        if (this.weightAttributeCombo.getSelectedIndex() == 0) {
            return null;
        }
        if (this.weightAttributeCombo.getSelectedItem() == null) {
            return null;
        }
        return this.weightAttributeCombo.getSelectedItem().toString();
    }

    public void updateWeightAttributeCombo() {
        Object currentItem = this.weightAttributeCombo.getSelectedItem();
        this.weightAttributeCombo.removeAllItems();
        this.weightAttributeCombo.addItem("[unweighted]");
        CyNetwork network = this.app.getCurrentNetwork();
        if (network == null) {
            return;
        }
        CyTable nodeTable = network.getDefaultEdgeTable();
        ArrayList<String> names = new ArrayList<String>();
        for (CyColumn column : nodeTable.getColumns()) {
            Class type = column.getType();
            if (type != Integer.class && type != Long.class && type != Float.class && type != Double.class || "SUID".equals(column.getName())) continue;
            names.add(column.getName());
        }
        Collections.sort(names);
        Collections.sort(names);
        for (String name : names) {
            this.weightAttributeCombo.addItem(name);
        }
        if (currentItem != null) {
            this.weightAttributeCombo.setSelectedItem(currentItem);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.algorithmParametersPanel) {
            this.selectionInfoPanel.setQualityFunction(this.getParameters().getQualityFunction());
            this.selectionInfoPanel.updateNodeSetFromSelection();
        }
    }

    public void activate() {
        this.app.registerService(this, CytoPanelComponent.class);
        this.app.registerService(this, NetworkAddedListener.class);
        this.app.registerService(this, NetworkDestroyedListener.class);
        this.app.registerService(this, SetCurrentNetworkListener.class);
        CytoPanel cytoPanel = this.app.getCySwingApplication().getCytoPanel(this.getCytoPanelName());
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        this.setVisible(true);
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent(this.getComponent()));
        this.updateWeightAttributeCombo();
    }

    public void deactivate() {
        this.app.unregisterService(this, CytoPanelComponent.class);
        this.app.unregisterService(this, NetworkAddedListener.class);
        this.app.unregisterService(this, NetworkDestroyedListener.class);
        this.app.unregisterService(this, SetCurrentNetworkListener.class);
    }

    private void updateCollapsiblePanelIcons() {
        ImageIcon expandedIcon;
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this);
        URL url = this.app.getResource(this.app.getResourcePathName() + "/plus.gif");
        ImageIcon collapsedIcon = url != null ? new ImageIcon(url) : null;
        url = this.app.getResource(this.app.getResourcePathName() + "/minus.gif");
        ImageIcon imageIcon = expandedIcon = url != null ? new ImageIcon(url) : null;
        while (!components.isEmpty()) {
            Component component = (Component)components.remove(components.size() - 1);
            if (component instanceof CollapsiblePanel) {
                ((CollapsiblePanel)component).setCollapsedIcon(collapsedIcon);
                ((CollapsiblePanel)component).setExpandedIcon(expandedIcon);
            }
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            components.addAll(Arrays.asList(container.getComponents()));
        }
    }

    public void handleEvent(NetworkAddedEvent event) {
        this.updateWeightAttributeCombo();
    }

    public void handleEvent(NetworkDestroyedEvent event) {
        this.updateWeightAttributeCombo();
    }

    public void handleEvent(SetCurrentNetworkEvent event) {
        this.updateWeightAttributeCombo();
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "ClusterONE";
    }
}

