/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.helper.SeriesViewer;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;

class ResultsFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Configuration.getSdmxLogger();
    private final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

    public ResultsFrame(final String string, List<PortableTimeSeries<Double>> list) throws HeadlessException {
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        JScrollPane jScrollPane = new JScrollPane();
        int n = list.size();
        if (n == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("Time Series");
        PortableTimeSeries<Double> portableTimeSeries = list.get(0);
        for (String object2 : portableTimeSeries.getDimensionsMap().keySet()) {
            vector.add(object2);
        }
        Vector vector2 = new Vector();
        for (PortableTimeSeries<Double> portableTimeSeries2 : list) {
            Vector<String> vector3 = new Vector<String>();
            vector3.add(portableTimeSeries2.getName());
            vector3.addAll(portableTimeSeries2.getDimensionsMap().values());
            vector2.add(vector3);
        }
        final JTable jTable = new JTable(vector2, vector){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setAutoCreateRowSorter(true);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                if (jTable.convertColumnIndexToModel(n2) == 0) {
                    try {
                        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                            JPopupMenu jPopupMenu = ResultsFrame.this.createPopupMenu(string, jTable, n);
                            jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                        } else if (n2 == 0 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                            new SeriesViewer(string, jTable.getValueAt(n, 0).toString()).setVisible(true);
                        }
                    }
                    catch (SdmxException sdmxException) {
                        LOGGER.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                        LOGGER.log(Level.FINER, "", sdmxException);
                    }
                }
            }
        });
        jScrollPane.setViewportView(jTable);
        this.getContentPane().add(jScrollPane);
    }

    private String[] getSelectedSeries(JTable jTable, int n) {
        int[] nArray = jTable.getSelectedRows();
        if (nArray.length == 0) {
            nArray = new int[]{n};
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = jTable.getValueAt(nArray[i], jTable.convertColumnIndexToView(0)).toString();
        }
        return stringArray;
    }

    private boolean isSameFreqSelectedSeries(JTable jTable, int n) {
        int[] nArray = jTable.getSelectedRows();
        if (nArray.length == 0) {
            nArray = new int[]{n};
        }
        Object object = jTable.getValueAt(nArray[0], jTable.convertColumnIndexToView(1));
        for (int i = 1; i < nArray.length; ++i) {
            if (object.equals(jTable.getValueAt(nArray[i], jTable.convertColumnIndexToView(1)))) continue;
            return false;
        }
        return true;
    }

    private JPopupMenu createPopupMenu(final String string, JTable jTable, int n) {
        final String[] stringArray = this.getSelectedSeries(jTable, n);
        boolean bl = this.isSameFreqSelectedSeries(jTable, n);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText("Copy " + (bl ? "selected " : "") + "series name" + (bl ? "s" : ""));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Arrays.toString(stringArray).replaceAll("\\[|\\s", "");
                ResultsFrame.this.clipboard.setContents(new StringSelection(string), null);
            }
        });
        jPopupMenu.add(jMenuItem);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (final String string2 : stringArray) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                new SeriesViewer(string, string2).setVisible(true);
                            }
                            catch (SdmxException sdmxException) {
                                LOGGER.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
                                LOGGER.log(Level.FINER, "", sdmxException);
                            }
                        }
                    });
                }
            }
        };
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText("Tabulate series");
        jMenuItem2.setEnabled(bl && stringArray.length <= 10);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new SeriesViewer(string, stringArray).setVisible(true);
                        }
                        catch (Exception exception) {
                            LOGGER.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                            LOGGER.log(Level.FINER, "", exception);
                        }
                    }
                });
            }
        });
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText("View series data");
        jMenuItem3.setEnabled(stringArray.length <= 5);
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.setText("Selected series: " + stringArray.length);
        jMenuItem4.setEnabled(false);
        jPopupMenu.add(jMenuItem4);
        return jPopupMenu;
    }
}

