/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Vector;

public class SparseSetOfItemsets {
    private int[] i;
    private int[] p;
    private int items;

    public SparseSetOfItemsets(int[] nArray, int[] nArray2, int n) {
        this.i = nArray;
        this.p = nArray2;
        this.items = n;
    }

    public SparseSetOfItemsets(AbstractCollection abstractCollection, int n) {
        Itemset itemset;
        int n2 = 0;
        this.items = n;
        Iterator iterator = abstractCollection.iterator();
        while (iterator.hasNext()) {
            itemset = (Itemset)iterator.next();
            n2 += itemset.size();
        }
        this.i = new int[n2];
        this.p = new int[abstractCollection.size() + 1];
        iterator = abstractCollection.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            itemset = (Itemset)iterator.next();
            this.p[n3 + 1] = this.p[n3] + itemset.size();
            for (int i = 0; i < itemset.size(); ++i) {
                this.i[this.p[n3] + i] = itemset.get(i);
            }
            ++n3;
        }
    }

    public Itemset getItemset(int n) {
        int[] nArray = new int[this.p[n + 1] - this.p[n]];
        int n2 = this.p[n];
        int n3 = 0;
        while (n2 < this.p[n + 1]) {
            nArray[n3] = this.i[n2];
            ++n2;
            ++n3;
        }
        return new Itemset(nArray);
    }

    public int size() {
        return this.p.length - 1;
    }

    public int items() {
        return this.items;
    }

    public int incidences() {
        return this.i.length;
    }

    public int[] getI() {
        return this.i;
    }

    public int[] getP() {
        return this.p;
    }

    public int getItems() {
        return this.items;
    }

    public String toString() {
        return "Sparse set of " + this.size() + " itemsets (" + this.items + " items)";
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 18, 3, 44, 5};
        int[] nArray2 = new int[]{1, 18, 3, 44};
        Itemset itemset = new Itemset(nArray);
        Itemset itemset2 = new Itemset(itemset, 11);
        Itemset itemset3 = new Itemset(nArray2);
        Vector<Itemset> vector = new Vector<Itemset>();
        vector.add(itemset);
        vector.add(itemset2);
        vector.add(itemset3);
        SparseSetOfItemsets sparseSetOfItemsets = new SparseSetOfItemsets(vector, 50);
        System.out.println(sparseSetOfItemsets);
        System.out.println("db.size(): " + sparseSetOfItemsets.size());
        System.out.println("db.items(): " + sparseSetOfItemsets.items());
        System.out.println("db.incidences(): " + sparseSetOfItemsets.incidences());
        System.out.println(sparseSetOfItemsets.getItemset(0));
        System.out.println(sparseSetOfItemsets.getItemset(1));
        System.out.println(sparseSetOfItemsets.getItemset(2));
    }
}

