/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.plots.OrdStats;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimBox;
import org.rosuda.ibase.toolkit.PPrimCircle;
import org.rosuda.ibase.toolkit.PPrimPolygon;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.ibase.toolkit.WinTracker;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.RespDialog;
import org.rosuda.util.SpacingPanel;
import org.rosuda.util.Tools;

public class ParallelAxesCanvas
extends BaseCanvas {
    private boolean valid = true;
    public static final int TYPE_PCP = 0;
    public static final int TYPE_BOX = 1;
    public static final int TYPE_PCPBOX = 2;
    private int type;
    private int MINWIDTH = 60;
    private int MINHEIGHT = 50;
    private int bigMLeft = 30;
    private int bigMTop = 20;
    private int bigMBottom = 20;
    private int bigMRight = 30;
    private int smallMLeft = 10;
    private int smallMTop = 10;
    private int smallMBottom = 10;
    private int smallMRight = 10;
    private int defaultMLeft;
    private int defaultMRight;
    private int defaultMTop;
    private int defaultMBottom;
    private boolean drawAxes = false;
    private boolean commonScale = false;
    private boolean useRegularPositioning = false;
    private int leftGap = 7;
    private int rightGap = 7;
    public boolean alterningLabels = true;
    private SVar[] v;
    private SVar xv;
    private SVar cv;
    private double totMin;
    private double totMax;
    private static final String M_MINUS = "-";
    private static final String M_LABELS = "labels";
    private static final String M_SHOWDOTS = "Show dots";
    private static final String M_TOGGLEPTS = "togglePts";
    private static final String M_NODESIZEUP = "nodeSizeUp";
    private static final String M_NODESIZEDOWN = "nodeSizeDown";
    private static final String M_SHOWAXES = "Show axes";
    private static final String M_TOGGLEAXES = "toggleAxes";
    private static final String M_HIDELINES = "Hide lines";
    private static final String M_TOGGLELINES = "toggleLines";
    private static final String M_HIDENALINES = "hideNAlines";
    private static final String M_COMMON = "common";
    private static final String M_YRANGEDLG = "YrangeDlg";
    private static final String M_SCALEDLG = "scaleDlg";
    private static final String M_PCP = "only pcp";
    private static final String M_BOX = "only box";
    private static final String M_BOTHPCPBOX = "both pcp and box";
    private static final String M_SORTBYCOUNT = "sortByCount";
    private static final String M_SORTBYMARKED = "sortByMarked";
    private static final String M_SORTBYMARKEDREL = "sortByMarkedRelative";
    private static final String M_SORTBYMEDIAN = "sortByMedian";
    private static final String M_SORTBYMAX = "sortByMax";
    private static final String M_SORTBYMIN = "sortByMin";
    private static final String M_SORTBYMARKEDMEDIAN = "sortByMarkedMedian";
    private static final String M_SORTBYMARKEDMAX = "sortByMarkedMax";
    private static final String M_SORTBYMARKEDMIN = "sortByMarkedMin";
    private static final String M_ALTERNINGLABELS = "alterningLabels";
    private MenuItem MIlabels = null;
    private MenuItem MIdots = null;
    private MenuItem MIaxes = null;
    private MenuItem MIlines = null;
    private MenuItem MInodeSizeUp = null;
    private MenuItem MInodeSizeDown = null;
    private MenuItem MIhideNAlines = null;
    private MenuItem MIPCP = null;
    private MenuItem MIBox = null;
    private MenuItem MIPCPBox = null;
    private MenuItem MIsortByCount = null;
    private MenuItem MIsortByMarked = null;
    private MenuItem MIsortByMarkedRel = null;
    private MenuItem MIsortByMedian = null;
    private MenuItem MIsortByMax = null;
    private MenuItem MIsortByMin = null;
    private MenuItem MIsortByMarkedMedian = null;
    private MenuItem MIsortByMarkedMax = null;
    private MenuItem MIsortByMarkedMin = null;
    private MenuItem MIAlterningLabels = null;
    private int boxwidth = 20;
    private int posBoxwidth = 20;
    private final int MAX_BOXWIDTH = 32;
    private final int MIN_BOXWIDTH = 4;
    private ArrayList invisiblePoints = null;
    private ArrayList boxes = null;
    private boolean vsCat = false;
    private int[][] rk;
    private int[] rs;
    private int cs;
    private Object[] cats;
    private OrdStats[] oss;
    private OrdStats OSdata;
    private OrdStats[] markStats;
    private boolean drawPoints = false;
    private boolean drawLines = true;
    private boolean drawNAlines = true;
    private boolean drawHidden = true;
    private ArrayList polylines = null;
    private int nodeSize = 2;
    public Color COL_AXES = Color.WHITE;
    public boolean isMouseOnHilite = false;
    protected int[] axcoordX;
    protected int[] axcoordY;
    protected int[][] aycoordX;
    protected int[][] aycoordY;

    public ParallelAxesCanvas(int n, Frame frame, SVar sVar, SVar sVar2, SMarker sMarker, int n2) {
        super(n, frame, sMarker);
        this.type = n2;
        this.initFlagsAndFields();
        this.allowDragMove = true;
        this.objectClipping = true;
        this.commonScale = false;
        this.setDefaultMargins(new int[]{this.smallMLeft, this.smallMRight, this.smallMTop, this.bigMBottom, this.bigMLeft, this.smallMRight, this.smallMTop, this.smallMBottom});
        this.mBottom = this.smallMBottom;
        this.mTop = this.smallMTop;
        this.mLeft = this.smallMLeft;
        this.mRight = this.smallMRight;
        this.v = new SVar[]{sVar};
        this.cv = sVar2;
        this.resetAxesCoord();
        this.xv = new SVarObj(this.getShortClassName() + ".index", true);
        for (int i = 0; i < this.cv.getNumCats(); ++i) {
            this.xv.add(this.cv.getCatAt(i).toString());
        }
        this.ax = new Axis(this.xv, 0, this.xv.isCat() ? 1 : 0);
        this.ax.addDepend(this);
        this.ay = new Axis(this.v[0], 1, 0);
        this.ay.addDepend(this);
        this.ay.setValueRange(this.v[0].getMin() - (this.v[0].getMax() - this.v[0].getMin()) / 20.0, (this.v[0].getMax() - this.v[0].getMin()) * 1.1);
        this.vsCat = true;
        this.createMenu(frame);
        this.MIPCP.setEnabled(false);
        this.MIPCPBox.setEnabled(false);
        this.setCommonScale(this.commonScale);
        EzMenu.getItem(this.getFrame(), M_COMMON).setEnabled(false);
        this.updateMargins();
        this.setTitle("Boxplot (" + this.v[0].getName() + " grouped by " + this.cv.getName() + ")");
        if (sVar != null && !sVar.isCat() && sVar.isNum() && sVar2.isCat()) {
            this.valid = true;
        }
        if (this.valid) {
            int n3;
            int n4;
            this.cs = this.cv.getNumCats();
            this.cats = this.cv.getCategories();
            int[] nArray = this.v[0].getRanked();
            this.oss = new OrdStats[this.cs * 2 + 2];
            this.rk = new int[this.cs * 2 + 2][];
            this.rs = new int[this.cs * 2 + 2];
            for (n4 = 0; n4 < this.cs; ++n4) {
                this.rs[n4] = 0;
                n3 = this.cv.getSizeCatAt(n4);
                this.rk[n4] = new int[n3];
                this.rk[this.cs + 1 + n4] = new int[n3];
                this.oss[n4] = new OrdStats();
                this.oss[this.cs + 1 + n4] = new OrdStats();
            }
            for (n4 = 0; n4 < nArray.length; ++n4) {
                n3 = this.cv.getCatIndex(this.cv.at(nArray[n4]));
                if (n3 < 0) {
                    n3 = this.cs;
                }
                this.rk[n3][this.rs[n3]] = nArray[n4];
                int n5 = n3;
                this.rs[n5] = this.rs[n5] + 1;
            }
            for (n4 = 0; n4 < this.cs; ++n4) {
                this.oss[n4].update(this.v[0], this.rk[n4], this.rs[n4]);
            }
            boolean[] blArray = new boolean[this.cs];
            int n6 = 0;
            for (n4 = 0; n4 < this.cs; ++n4) {
                if (this.oss[n4].lastR == null) {
                    blArray[n4] = false;
                    ++n6;
                    continue;
                }
                blArray[n4] = true;
            }
            if (n6 > 0) {
                OrdStats[] ordStatsArray = new OrdStats[2 * (this.cs - n6) + 2];
                int n7 = 0;
                for (n4 = 0; n4 < this.cs; ++n4) {
                    if (!blArray[n4]) continue;
                    ordStatsArray[n7++] = this.oss[n4];
                }
                ordStatsArray[this.cs] = this.oss[this.cs];
                n7 = 0;
                for (n4 = 0; n4 < this.cs; ++n4) {
                    if (!blArray[n4]) continue;
                    ordStatsArray[this.cs - n6 + 1 + n7++] = this.oss[this.cs + 1 + n4];
                }
                this.oss = ordStatsArray;
                this.cs -= n6;
            }
            this.updateObjects();
        }
        this.objectClipping = true;
        this.dontPaint = false;
    }

    public ParallelAxesCanvas(int n, Frame frame, SVar sVar, SMarker sMarker, int n2) {
        this(n, frame, new SVar[]{sVar}, sMarker, n2);
    }

    public ParallelAxesCanvas(int n, Frame frame, SVar[] sVarArray, SMarker sMarker, int n2) {
        super(n, frame, sMarker);
        this.type = n2;
        this.initFlagsAndFields();
        this.allowDragMove = true;
        this.objectClipping = true;
        if (sVarArray.length == 1) {
            this.commonScale = true;
        }
        if (n2 == 1 || n2 == 2) {
            this.setDefaultMargins(new int[]{this.smallMLeft, this.smallMRight, this.smallMTop, this.smallMBottom});
        } else {
            this.setDefaultMargins(new int[]{this.smallMLeft, this.smallMRight, this.bigMTop, this.bigMBottom, this.bigMLeft, this.smallMRight, this.smallMTop, this.smallMBottom});
        }
        this.v = new SVar[sVarArray.length];
        this.opAy = new Axis[sVarArray.length - 1];
        this.xv = new SVarObj(this.getShortClassName() + ".index", true);
        for (int i = 0; i < sVarArray.length; ++i) {
            if (sVarArray[i].isNum()) {
                if (i == 0) {
                    this.totMin = sVarArray[i].getMin();
                    this.totMax = sVarArray[i].getMax();
                } else {
                    if (sVarArray[i].getMin() < this.totMin) {
                        this.totMin = sVarArray[i].getMin();
                    }
                    if (sVarArray[i].getMax() > this.totMax) {
                        this.totMax = sVarArray[i].getMax();
                    }
                }
            }
            this.xv.add(sVarArray[i].getName());
            this.v[i] = sVarArray[i];
        }
        this.ax = new Axis(this.xv, 0, this.xv.isCat() ? 1 : 0);
        this.ax.addDepend(this);
        this.ay = new Axis(sVarArray[0], 1, sVarArray[0].isCat() ? 1 : 0);
        this.ay.addDepend(this);
        this.createMenu(frame);
        if (this.v.length == 1) {
            this.MIPCPBox.setEnabled(false);
            this.MIPCP.setEnabled(false);
        }
        this.setCommonScale(this.commonScale);
        this.updateMargins();
        if (n2 == 1 || n2 == 2) {
            this.initOss(sVarArray);
        }
        this.dontPaint = false;
    }

    private void createMenu(Frame frame) {
        this.createMenu(frame, true, true, true, false, new String[]{"@LHide Labels", M_LABELS, "Alternating Labels", M_ALTERNINGLABELS, M_SHOWDOTS, M_TOGGLEPTS, "Increase Dot Size (up)", M_NODESIZEUP, "Decrease Dot Size (down)", M_NODESIZEDOWN, M_SHOWAXES, M_TOGGLEAXES, M_HIDELINES, M_TOGGLELINES, "@NHide NA Lines", M_HIDENALINES, M_MINUS, "@TCommon Scale", M_COMMON, M_MINUS, "Set Y Range ...", M_YRANGEDLG, "!SShow Scale Dialog", M_SCALEDLG, M_MINUS, "PCP", M_PCP, "Box Plot", M_BOX, "PCP Over Boxes", M_BOTHPCPBOX, M_MINUS, "@OSort by Count", M_SORTBYCOUNT, "!OSort by Highlighted", M_SORTBYMARKED, "Sort by Highlighted Proportion", M_SORTBYMARKEDREL, "@ESort by Median", M_SORTBYMEDIAN, "@MSort by Minimum", M_SORTBYMIN, "!MSort by maximum", M_SORTBYMAX, "Sort by Median of Highlighted", M_SORTBYMARKEDMEDIAN, "Sort by Minimum of Highlighted", M_SORTBYMARKEDMIN, "Sort by Maximum of Highlighted", M_SORTBYMARKEDMAX});
        this.MIlabels = EzMenu.getItem(frame, M_LABELS);
        this.MIdots = EzMenu.getItem(frame, M_TOGGLEPTS);
        this.MIaxes = EzMenu.getItem(frame, M_TOGGLEAXES);
        this.MIlines = EzMenu.getItem(frame, M_TOGGLELINES);
        this.MIlines.setEnabled(false);
        this.MInodeSizeUp = EzMenu.getItem(frame, M_NODESIZEUP);
        this.MInodeSizeUp.setEnabled(false);
        this.MInodeSizeDown = EzMenu.getItem(frame, M_NODESIZEDOWN);
        this.MInodeSizeUp.setEnabled(false);
        this.MIhideNAlines = EzMenu.getItem(frame, M_HIDENALINES);
        this.MIhideNAlines.setEnabled(this.type == 0);
        this.MItransHighl = EzMenu.getItem(frame, "transparentHighlighting");
        this.MIPCP = EzMenu.getItem(frame, M_PCP);
        this.MIBox = EzMenu.getItem(frame, M_BOX);
        this.MIPCPBox = EzMenu.getItem(frame, M_BOTHPCPBOX);
        this.MIsortByCount = EzMenu.getItem(frame, M_SORTBYCOUNT);
        this.MIsortByMarked = EzMenu.getItem(frame, M_SORTBYMARKED);
        this.MIsortByMarkedRel = EzMenu.getItem(frame, M_SORTBYMARKEDREL);
        this.MIsortByMedian = EzMenu.getItem(frame, M_SORTBYMEDIAN);
        this.MIsortByMax = EzMenu.getItem(frame, M_SORTBYMAX);
        this.MIsortByMin = EzMenu.getItem(frame, M_SORTBYMIN);
        this.MIsortByMarkedMedian = EzMenu.getItem(frame, M_SORTBYMARKEDMEDIAN);
        this.MIsortByMarkedMax = EzMenu.getItem(frame, M_SORTBYMARKEDMAX);
        this.MIsortByMarkedMin = EzMenu.getItem(frame, M_SORTBYMARKEDMIN);
        this.MIAlterningLabels = EzMenu.getItem(frame, M_ALTERNINGLABELS);
        this.updateSortingMenus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.run(this, M_NODESIZEUP);
        }
        if (keyEvent.getKeyCode() == 40) {
            this.run(this, M_NODESIZEDOWN);
        }
        super.keyPressed(keyEvent);
    }

    public Object run(Object object, String string) {
        Component component;
        Component component2;
        Object object2;
        Iterator iterator;
        if ("print".equals(string)) {
            this.drawHidden = false;
            this.run(object, "exportPS");
            this.drawHidden = true;
            return this;
        }
        super.run(object, string);
        if (M_LABELS.equals(string)) {
            this.setShowLabels(!this.isShowLabels());
            this.MIlabels.setLabel(this.isShowLabels() ? "Hide Labels" : "Show Labels");
            this.setUpdateRoot(0);
            this.repaint();
        }
        if ("exit".equals(string)) {
            WinTracker.current.Exit();
        }
        if (M_COMMON.equals(string)) {
            this.setCommonScale(!this.commonScale);
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_TOGGLEPTS.equals(string)) {
            this.drawPoints = !this.drawPoints;
            this.MIdots.setLabel(this.drawPoints ? "Hide Dots" : M_SHOWDOTS);
            iterator = this.polylines.iterator();
            while (iterator.hasNext()) {
                ((PPrimPolygon)iterator.next()).drawCorners = this.drawPoints;
            }
            this.MIdots.setEnabled(!this.drawPoints || this.drawLines);
            this.MIlines.setEnabled(this.drawPoints || !this.drawLines);
            this.MInodeSizeDown.setEnabled(this.drawPoints);
            this.MInodeSizeUp.setEnabled(this.drawPoints);
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_TOGGLELINES.equals(string)) {
            this.drawLines = !this.drawLines;
            this.MIlines.setLabel(this.drawLines ? M_HIDELINES : "Show Lines");
            iterator = this.polylines.iterator();
            while (iterator.hasNext()) {
                object2 = (PPrimPolygon)iterator.next();
                ((PPrimPolygon)object2).drawBorder = this.drawLines;
                ((PPrimPolygon)object2).selectByCorners = !this.drawLines;
            }
            this.MIdots.setEnabled(!this.drawPoints || this.drawLines);
            this.MIlines.setEnabled(this.drawPoints || !this.drawLines);
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_TOGGLEAXES.equals(string)) {
            this.drawAxes = !this.drawAxes;
            this.MIaxes.setLabel(this.drawAxes ? "Hide Axes" : M_SHOWAXES);
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_YRANGEDLG.equals(string) || "XrangeDlg".equals(string)) {
            iterator = M_YRANGEDLG.equals(string) ? this.ay : this.ax;
            this.intDlg = new Dialog(this.myFrame, iterator == this.ay ? "Y Range" : "X Range", true);
            object2 = this.intDlg;
            ((Dialog)object2).setBackground(Color.white);
            ((Container)object2).setLayout(new BorderLayout());
            ((Container)object2).add((Component)new SpacingPanel(), "West");
            ((Container)object2).add((Component)new SpacingPanel(), "East");
            component2 = new Panel();
            ((Container)component2).setLayout(new FlowLayout());
            component = new Button("OK");
            ((Container)component2).add(component);
            Button button = new Button("Cancel");
            ((Container)component2).add(button);
            ((Container)object2).add(component2, "South");
            ((Container)object2).add((Component)new Label(" "), "North");
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            ((Container)object2).add(panel);
            panel.add(new Label("start: "));
            TextField textField = new TextField("" + ((Axis)((Object)iterator)).vBegin, 6);
            TextField textField2 = new TextField("" + (((Axis)((Object)iterator)).vBegin + ((Axis)((Object)iterator)).vLen), 6);
            panel.add(textField);
            panel.add(new Label(", end: "));
            panel.add(textField2);
            ((Window)object2).pack();
            PGSCanvas.IDlgCL iDlgCL = new PGSCanvas.IDlgCL(this);
            ((Button)component).addActionListener(iDlgCL);
            button.addActionListener(iDlgCL);
            ((Dialog)object2).setVisible(true);
            if (!this.cancel) {
                double d = Tools.parseDouble(textField.getText());
                double d2 = Tools.parseDouble(textField2.getText());
                ((Axis)((Object)iterator)).setValueRange(d, d2 - d);
                this.setUpdateRoot(0);
                this.repaint();
            }
            ((Window)object2).dispose();
            this.updateGeometry = true;
        }
        if (M_SCALEDLG.equals(string) && this.commonScale) {
            iterator = new RespDialog(this.myFrame, "Set Y Scale", true, RespDialog.okCancel);
            object2 = ((RespDialog)((Object)iterator)).getContentPanel();
            ((Container)object2).add(new Label("begin: "));
            component2 = new TextField("" + this.ay.vBegin, 6);
            component = new TextField("" + (this.ay.vBegin + this.ay.vLen), 6);
            ((Container)object2).add(component2);
            ((Container)object2).add(new Label(", end: "));
            ((Container)object2).add(component);
            ((Window)((Object)iterator)).pack();
            ((Dialog)((Object)iterator)).setVisible(true);
            if (!this.cancel) {
                double d = Tools.parseDouble(((TextComponent)component2).getText());
                double d3 = Tools.parseDouble(((TextComponent)component).getText());
                if (d3 - d > 0.0) {
                    this.ay.setValueRange(d, d3 - d);
                }
                if (this.myFrame != null) {
                    this.myFrame.pack();
                }
            }
            ((Window)((Object)iterator)).dispose();
            this.updateGeometry = true;
        }
        if (M_NODESIZEUP.equals(string)) {
            ++this.nodeSize;
            if (this.polylines != null && this.polylines.size() > 0) {
                iterator = this.polylines.iterator();
                while (iterator.hasNext()) {
                    ((PPrimPolygon)iterator.next()).setNodeSize(this.nodeSize);
                }
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_NODESIZEDOWN.equals(string)) {
            --this.nodeSize;
            if (this.polylines != null && this.polylines.size() > 0) {
                iterator = this.polylines.iterator();
                while (iterator.hasNext()) {
                    ((PPrimPolygon)iterator.next()).setNodeSize(this.nodeSize);
                }
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
        if (M_HIDENALINES.equals(string)) {
            boolean bl = this.drawNAlines = !this.drawNAlines;
            if (this.polylines != null && this.polylines.size() > 0) {
                iterator = this.polylines.iterator();
                while (iterator.hasNext()) {
                    ((PPrimPolygon)iterator.next()).showInvisibleLines = this.drawNAlines;
                }
                this.setUpdateRoot(0);
                this.repaint();
            }
            this.MIhideNAlines.setLabel(this.drawNAlines ? "Hide NA Lines" : "Show NA Lines");
        }
        if (M_PCP.equals(string)) {
            this.type = 0;
            this.initFlagsAndFields();
            this.updateMargins();
            this.updateObjects();
            this.updateSortingMenus();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_BOX.equals(string)) {
            this.type = 1;
            this.initFlagsAndFields();
            this.updateMargins();
            if (this.oss == null) {
                this.initOss(this.v);
            }
            this.updateObjects();
            this.updateSortingMenus();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_BOTHPCPBOX.equals(string)) {
            this.type = 2;
            this.initFlagsAndFields();
            this.updateMargins();
            if (this.oss == null) {
                this.initOss(this.v);
            }
            this.updateObjects();
            this.updateSortingMenus();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_SORTBYCOUNT.equals(string)) {
            int n = this.pp.length - this.invisiblePoints.size();
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = this.getCount(i);
            }
            this.sortAxesBy((int[])object2);
        }
        if (M_SORTBYMARKED.equals(string)) {
            int n = this.pp.length - this.invisiblePoints.size();
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = this.getMarked(i);
            }
            this.sortAxesBy((int[])object2);
        }
        if (M_SORTBYMARKEDREL.equals(string)) {
            int n = this.pp.length - this.invisiblePoints.size();
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = this.getMarked(i) / this.getCount(i);
            }
            this.sortAxesBy((int[])object2);
        }
        if (M_SORTBYMEDIAN.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((PPrimBox)this.pp[i]).medValue;
            }
            this.sortAxesBy(dArray);
        }
        if (M_SORTBYMIN.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.v[i].getMin();
            }
            this.sortAxesBy(dArray);
        }
        if (M_SORTBYMAX.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.v[i].getMax();
            }
            this.sortAxesBy(dArray);
        }
        if (M_SORTBYMARKEDMEDIAN.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.markStats[i].med;
            }
            this.sortAxesBy(dArray);
        }
        if (M_SORTBYMARKEDMIN.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((PPrimBox)this.pp[i]).sminValue;
            }
            this.sortAxesBy(dArray);
        }
        if (M_SORTBYMARKEDMAX.equals(string)) {
            double[] dArray = new double[this.pp.length - this.invisiblePoints.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((PPrimBox)this.pp[i]).smaxValue;
            }
            this.sortAxesBy(dArray);
        }
        if (M_ALTERNINGLABELS.equals(string)) {
            this.MIAlterningLabels.setLabel(this.alterningLabels ? "Alternating Labels" : "Bottom Labels");
            this.alterningLabels = !this.alterningLabels;
            this.repaint();
        }
        return null;
    }

    public SVar getData(int n) {
        switch (this.type) {
            case 1: {
                if (this.cv == null) break;
                return n == 0 ? this.v[0] : (n == 1 ? this.cv : null);
            }
        }
        return n >= 0 && n < this.v.length ? this.v[n] : null;
    }

    public void performZoomIn(int n, int n2, int n3, int n4) {
        if (this.commonScale) {
            super.performZoomIn(n, n2, n3, n4, null, this.ay);
        } else {
            int n5 = 0;
            int n6 = this.v.length - 1;
            while (this.getAxCatPos(this.ax.getCatAtSeqIndex(n5)) < n) {
                ++n5;
            }
            while (this.getAxCatPos(this.ax.getCatAtSeqIndex(n6)) > n3) {
                --n6;
            }
            this.dontPaint = true;
            for (int i = n5; i <= n6; ++i) {
                int n7 = this.ax.getCatAtSeqIndex(i);
                super.performZoomIn(n, n2, n3, n4, null, n7 == 0 ? this.ay : this.opAy[n7 - 1]);
            }
            this.dontPaint = false;
        }
    }

    public void resetZoom() {
        if (this.commonScale) {
            super.resetZoom();
        } else {
            for (int i = 0; i < this.opAy.length; ++i) {
                this.opAy[i] = new Axis(this.v[i + 1], 1, this.v[i + 1].isCat() ? 1 : 0);
                this.opAy[i].addDepend(this);
            }
            this.updateGeometry = true;
            this.ay.setDefaultRange();
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
    }

    private void setCommonScale(boolean bl) {
        this.commonScale = bl;
        this.updateGeometry = true;
        this.updateMargins();
        EzMenu.getItem(this.getFrame(), M_COMMON).setLabel(bl ? "Individual Scales" : "Common Scale");
        EzMenu.getItem(this.getFrame(), M_YRANGEDLG).setEnabled(bl);
        if (bl) {
            this.ay.setType(0);
            this.ay.setValueRange(this.totMin - (this.totMax - this.totMin) / 20.0, (this.totMax - this.totMin) * 1.1);
        } else {
            if (this.opAy != null && this.opAy.length > 0 && this.opAy[0] == null) {
                for (int i = 0; i < this.opAy.length; ++i) {
                    this.opAy[i] = new Axis(this.v[i + 1], 1, this.v[i + 1].isCat() ? 1 : 0);
                    this.opAy[i].addDepend(this);
                    this.opAy[i].setValueRange(this.v[i + 1].getMin() - (this.v[i + 1].getMax() - this.v[i + 1].getMin()) / 20.0, (this.v[i + 1].getMax() - this.v[i + 1].getMin()) * 1.1);
                }
            }
            this.ay.setType(this.v[0].isCat() ? 1 : 0);
            this.ay.setValueRange(this.v[0].getMin() - (this.v[0].getMax() - this.v[0].getMin()) / 20.0, (this.v[0].getMax() - this.v[0].getMin()) * 1.1);
        }
    }

    private String getShortClassName() {
        switch (this.type) {
            case 1: {
                return "Box";
            }
            case 0: {
                return "PCP";
            }
        }
        return "PA";
    }

    public void paintBack(PoGraSS poGraSS) {
        int n;
        if (this.drawAxes) {
            poGraSS.setColor(this.COL_AXES);
            poGraSS.setLineWidth(1.5f);
            int n2 = 0;
            while (n2 < this.xv.getNumCats()) {
                n = this.getAxCatPos(n2++);
                if (this.orientation == 0) {
                    poGraSS.drawLine(n, this.mTop, n, this.getSize().height - this.mBottom);
                    continue;
                }
                poGraSS.drawLine(this.mLeft, n, this.getSize().width - this.mRight, n);
            }
            poGraSS.setLineWidth(1.0f);
        }
        Rectangle rectangle = this.getBounds();
        poGraSS.setBounds(rectangle.width, rectangle.height);
        if (!this.getValid()) {
            n = this.getHeight();
            int n3 = this.getWidth();
            poGraSS.setColor(this.COL_INVALID);
            poGraSS.drawLine(0, 0, n3, n);
            poGraSS.drawLine(0, n3, n, 0);
            return;
        }
        poGraSS.setColor(this.COL_OUTLINE);
        this.startAddingLabels();
        this.addLabelsAndTicks(poGraSS);
        this.endAddingLabels();
    }

    private boolean getValid() {
        return this.valid && this.getWidth() >= this.MINWIDTH && this.getHeight() >= this.MINHEIGHT;
    }

    private void addLabelsAndTicks(PoGraSS poGraSS) {
        int n;
        if (this.type == 0 || this.vsCat || this.v.length > 1) {
            int n2;
            if (this.isShowLabels()) {
                int n3;
                n2 = this.xv.getNumCats();
                int[] nArray = new int[n2];
                String[] stringArray = new String[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray[this.ax.getCatSeqIndex((int)n3)] = (this.type == 1 || this.type == 2) && ((PPrimBase)this.pp[n3]).isDragging() ? ((PPrimBox)this.pp[n3]).x + this.boxwidth / 2 : this.getAxCatPos(n3);
                    stringArray[this.ax.getCatSeqIndex((int)n3)] = (String)this.ax.getVariable().getCatAt(n3);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (stringArray[n3] == null) continue;
                    if (this.orientation == 0) {
                        n = this.alterningLabels ? ((n3 & 1) == 0 ? 1 : 0) : 1;
                        int n4 = -1;
                        double d = 0.5;
                        double d2 = 0.5;
                        switch (this.type) {
                            case 1: {
                                if (this.alterningLabels) {
                                    int n5;
                                    int n6;
                                    if (nArray.length <= 1) break;
                                    if (n3 == 0) {
                                        n6 = this.type == 1 && ((PPrimBase)this.pp[1]).isDragging() ? (nArray.length > 2 ? (nArray[2] - nArray[0]) / 2 : this.getBounds().width - this.mRight) : nArray[1];
                                        n5 = nArray[0] - this.posBoxwidth / 2;
                                    } else if (n3 == nArray.length - 1) {
                                        n6 = nArray[n3] + this.posBoxwidth / 2;
                                        n5 = this.type == 1 && ((PPrimBase)this.pp[n3 - 1]).isDragging() ? (n3 > 1 ? (nArray[n3] - nArray[n3 - 2]) / 2 : this.mLeft) : nArray[n3 - 1];
                                    } else {
                                        n6 = this.type == 1 && ((PPrimBase)this.pp[n3 + 1]).isDragging() ? (nArray.length > n3 + 2 ? (nArray[n3 + 2] - nArray[n3]) / 2 : this.getBounds().width - this.mRight) : nArray[n3 + 1];
                                        n5 = this.type == 1 && ((PPrimBase)this.pp[n3 - 1]).isDragging() ? (n3 > 1 ? (nArray[n3] - nArray[n3 - 2]) / 2 : this.mLeft) : nArray[n3 - 1];
                                    }
                                    n4 = n6 - n5;
                                    break;
                                }
                                n4 = this.posBoxwidth;
                                break;
                            }
                            case 0: {
                                if (this.alterningLabels) {
                                    if (n3 == 0) {
                                        if (nArray.length > 1) {
                                            n4 = nArray[1] - nArray[0];
                                        }
                                    } else if (n3 == nArray.length - 1) {
                                        if (n3 > 0) {
                                            n4 = nArray[n3] - nArray[n3 - 1];
                                        }
                                    } else if (n3 + 1 < nArray.length && n3 - 1 >= 0) {
                                        n4 = nArray[n3 + 1] - nArray[n3 - 1];
                                    }
                                } else {
                                    n4 = n3 == 0 ? (nArray[1] - nArray[0]) / 2 : (n3 == nArray.length - 1 ? (nArray[n3] - nArray[n3 - 1]) / 2 : (nArray[n3 + 1] - nArray[n3 - 1]) / 2);
                                }
                                d = n3 == 0 ? 0.0 : (n3 == nArray.length - 1 ? 1.0 : 0.5);
                                d2 = n != 0 ? 1.0 : 0.0;
                            }
                        }
                        this.xLabels.add((double)nArray[n3], n != 0 || !this.alterningLabels ? (double)(this.H - this.mBottom + 2) : (double)(this.mTop - 5), d, d2, n4, stringArray[n3]);
                        continue;
                    }
                    this.yLabels.add((double)(this.mLeft - 4), (double)nArray[n3], 1.0, 0.5, this.mLeft - 4, stringArray[n3]);
                }
            }
            if (this.type == 0) {
                n2 = this.orientation == 0 ? this.getSize().height - this.mBottom : this.getSize().width - this.mRight;
                for (int i = 0; i < this.xv.getNumCats(); ++i) {
                    int n7 = this.getAxCatPos(i);
                    if (this.orientation == 0) {
                        if (!this.alterningLabels || (this.ax.getCatSeqIndex(i) & 1) == 0) {
                            poGraSS.drawLine(n7, n2, n7, n2 + 2);
                            continue;
                        }
                        poGraSS.drawLine(n7, this.mTop, n7, this.mTop - 2);
                        continue;
                    }
                    poGraSS.drawLine(this.mLeft, n7, this.mLeft - 2, n7);
                }
            }
        }
        if (this.commonScale || this.type == 1 && this.vsCat) {
            if (this.orientation == 0) {
                if (this.isShowLabels()) {
                    this.addYLabels(poGraSS, this.ay, true, false);
                }
            } else {
                double d = this.orientation == 0 ? this.ay.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist) : this.ay.getSensibleTickDistance(this.horizontalMedDist, this.horizontalMinDist);
                for (double d3 = this.ay.getSensibleTickStart(d); d3 < this.ay.vBegin + this.ay.vLen; d3 += d) {
                    n = this.ay.getValuePos(d3);
                    poGraSS.drawLine(n, this.getHeight() - this.mBottom, n, this.getHeight() - this.mBottom + 2);
                    if (!this.isShowLabels()) continue;
                    this.xLabels.add(n, this.getHeight() - this.mBottom + 2, 0.5, 1.0, this.ay.getDisplayableValue(d3));
                }
            }
            if (this.orientation == 0) {
                poGraSS.drawLine(this.mLeft, this.mTop, this.mLeft, this.getSize().height - this.mBottom);
            } else {
                poGraSS.drawLine(this.mLeft, this.getHeight() - this.mBottom, this.getWidth() - this.mRight, this.getHeight() - this.mBottom);
            }
        }
    }

    public boolean adjustMargin(PoGraSS poGraSS) {
        switch (this.type) {
            case 0: {
                if (this.orientation != 0 || this.commonScale) break;
                return false;
            }
            case 1: {
                if (this.orientation != 0 || this.commonScale || this.vsCat || this.v.length <= 1) break;
                return false;
            }
        }
        if (this.orientation == 0) {
            double d = this.ay.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
            int n = 0;
            for (double d2 = this.ay.getSensibleTickStart(d); d2 < this.ay.vBegin + this.ay.vLen; d2 += d) {
                String string = this.ay.getDisplayableValue(d2);
                int n2 = poGraSS.getWidthEstimate(string);
                if (n2 <= n) continue;
                n = n2;
            }
            return this.adjustMargin(n);
        }
        int n = 0;
        for (int i = 0; i < this.xv.getNumCats(); ++i) {
            String string = (String)this.ax.getVariable().getCatAt(i);
            int n3 = poGraSS.getWidthEstimate(string);
            if (n3 <= n) continue;
            n = n3;
        }
        return this.adjustMargin(n);
    }

    private boolean adjustMargin(int n) {
        int n2 = this.mLeft;
        this.mLeft = (n += 6) > this.defaultMLeft - 3 ? n + 3 : this.defaultMLeft;
        if (this.mLeft > n2) {
            return true;
        }
        this.mLeft = n2;
        return false;
    }

    private void updateMargins() {
        block0 : switch (this.type) {
            case 1: {
                switch (this.orientation) {
                    case 0: {
                        if (this.vsCat) {
                            this.defaultMLeft = this.commonScale ? this.bigMLeft : this.smallMLeft;
                            this.mLeft = this.defaultMLeft;
                            break;
                        }
                        this.defaultMLeft = this.commonScale || this.v.length == 1 ? this.bigMLeft : this.smallMLeft;
                        this.mLeft = this.defaultMLeft;
                        this.defaultMBottom = this.v.length == 1 ? this.smallMBottom : this.bigMBottom;
                        this.mBottom = this.defaultMBottom;
                        break;
                    }
                    case 1: {
                        if (this.vsCat) {
                            this.defaultMBottom = this.commonScale ? this.bigMBottom : this.smallMBottom;
                            this.mBottom = this.defaultMBottom;
                            break;
                        }
                        this.defaultMLeft = this.v.length == 1 ? this.smallMLeft : this.bigMLeft;
                        this.mLeft = this.defaultMLeft;
                        this.defaultMBottom = this.commonScale || this.v.length == 1 ? this.bigMBottom : this.smallMBottom;
                        this.mBottom = this.defaultMBottom;
                    }
                }
                break;
            }
            case 0: {
                switch (this.orientation) {
                    case 0: {
                        this.defaultMLeft = this.commonScale ? this.bigMLeft : this.smallMLeft;
                        this.mLeft = this.defaultMLeft;
                        break block0;
                    }
                    case 1: {
                        this.defaultMBottom = this.commonScale ? this.bigMBottom : this.smallMBottom;
                        this.mBottom = this.defaultMBottom;
                    }
                }
            }
        }
    }

    public void paintInit(PoGraSS poGraSS) {
        super.paintInit(poGraSS);
        if (this.type == 1 && this.ax != null && (this.v.length > 1 || this.vsCat)) {
            int n = this.boxwidth;
            int n2 = Math.max((this.getAxCatPos(this.ax.getCatAtSeqIndex(1)) - this.getAxCatPos(this.ax.getCatAtSeqIndex(0))) * 8 / 10, 4);
            this.boxwidth = Math.min(n2, 32);
            this.posBoxwidth = n2;
            if (this.boxwidth != n) {
                this.updateObjects();
            }
        }
    }

    private int getAxCasePos(int n) {
        return this.useRegularPositioning ? this.getAxCatPos(this.ax.getCatByPos(this.ax.getCasePos(n))) : this.ax.getCasePos(n);
    }

    private int getAxCatPos(int n) {
        return this.useRegularPositioning ? this.ax.getRegularCatPos(n, this.leftGap, this.rightGap) : this.ax.getCatCenter(n);
    }

    private void initFlagsAndFields() {
        switch (this.type) {
            case 1: {
                this.useRegularPositioning = false;
                this.bigMRight = 30;
                this.bigMLeft = 30;
                if (this.invisiblePoints == null) {
                    this.invisiblePoints = new ArrayList(250);
                }
                if (this.boxes != null) break;
                this.boxes = new ArrayList(8);
                break;
            }
            case 0: {
                this.useRegularPositioning = true;
                this.bigMRight = 15;
                this.bigMLeft = 15;
                if (this.polylines != null) break;
                this.polylines = new ArrayList(500);
                break;
            }
            case 2: {
                this.useRegularPositioning = false;
                this.bigMRight = 30;
                this.bigMLeft = 30;
                if (this.invisiblePoints == null) {
                    this.invisiblePoints = new ArrayList(250);
                }
                if (this.boxes == null) {
                    this.boxes = new ArrayList(8);
                }
                if (this.polylines != null) break;
                this.polylines = new ArrayList(500);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        PlotPrimitive plotPrimitive = this.getFirstPrimitiveContaining(n2, n = mouseEvent.getY());
        if (plotPrimitive != null) {
            this.isMouseOnHilite = plotPrimitive.hilitcontains(n2, n);
        }
        super.mouseMoved(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.baseDrag && this.moveDrag) {
            int n = this.orientation == 0 ? mouseEvent.getX() : mouseEvent.getY();
            int n2 = this.ax.getCatByPos(n);
            int n3 = this.ax.getCatByPos(this.orientation == 0 ? this.baseDragX1 : this.baseDragY1);
            int n4 = this.ax.getCatSeqIndex(n3);
            int n5 = this.ax.getCatLow(n2);
            int n6 = this.ax.getCatUp(n2);
            int n7 = n - this.getAxCatPos(n2);
            if (Math.abs(n7) > (n6 - n5) / 4) {
                int n8 = this.ax.getCatSeqIndex(n2);
                if (n7 > 0) {
                    ++n8;
                }
                if (n4 < n8) {
                    --n8;
                }
                this.ax.moveCat(n3, n8);
            } else {
                this.ax.swapCats(n2, n3);
            }
            this.baseDrag = false;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.MINWIDTH, this.MINHEIGHT);
    }

    private PPrimBox createBox(OrdStats ordStats, int n, int n2, int n3) {
        Axis axis = this.commonScale || n3 == 0 ? this.ay : this.opAy[n3 - 1];
        PPrimBox pPrimBox = new PPrimBox();
        pPrimBox.x = n;
        pPrimBox.w = n2;
        pPrimBox.med = axis.getValuePos(ordStats.med);
        pPrimBox.lh = axis.getValuePos(ordStats.lh);
        pPrimBox.uh = axis.getValuePos(ordStats.uh);
        pPrimBox.lh15 = axis.getValuePos(ordStats.lh15);
        pPrimBox.uh15 = axis.getValuePos(ordStats.uh15);
        pPrimBox.medValue = ordStats.med;
        pPrimBox.lhValue = ordStats.lh;
        pPrimBox.uhValue = ordStats.uh;
        pPrimBox.lh15Value = ordStats.lh15;
        pPrimBox.uh15Value = ordStats.uh15;
        pPrimBox.lh3 = ordStats.lh3;
        pPrimBox.uh3 = ordStats.uh3;
        pPrimBox.lowEdge = ordStats.lowEdge;
        pPrimBox.lastR = new double[ordStats.lastR.length];
        pPrimBox.valPos = new int[ordStats.lastR.length];
        for (int i = 0; i < pPrimBox.lastR.length; ++i) {
            pPrimBox.lastR[i] = this.v[n3].atF(ordStats.lastR[i]);
            pPrimBox.valPos[i] = axis.getValuePos(pPrimBox.lastR[i]);
        }
        pPrimBox.lastTop = ordStats.lastTop;
        pPrimBox.highEdge = ordStats.highEdge;
        return pPrimBox;
    }

    public void updateObjects() {
        if (!this.getValid()) {
            return;
        }
        switch (this.type) {
            case 1: {
                this.initBoxes(0);
                break;
            }
            case 0: {
                if (this.pp == null || this.pp.length != this.v[0].size()) {
                    this.pp = new PlotPrimitive[this.v[0].size()];
                }
                this.initPolylines(0);
                break;
            }
            case 2: {
                this.initBoxes(this.v[0].size());
                this.initPolylines(this.v.length);
            }
        }
    }

    public void paintPost(PoGraSS poGraSS) {
        if (this.baseDrag && this.moveDrag) {
            if (this.type == 0) {
                int n = this.getBounds().height - this.mBottom;
                int n2 = this.orientation == 0 ? this.baseDragX2 : this.baseDragY2;
                int n3 = this.ax.getCatByPos(n2);
                int n4 = this.ax.getCatLow(n3);
                int n5 = this.ax.getCatUp(n3);
                int n6 = n2 - this.getAxCatPos(n3);
                if (Math.abs(n6) > (n5 - n4) / 4) {
                    int n7;
                    int n8;
                    if (n6 > 0) {
                        n8 = this.ax.getCatCenter(n3);
                        n7 = 2 * (n5 - n8);
                    } else {
                        n7 = 2 * (this.ax.getCatCenter(n3) - n4);
                        n8 = this.ax.getCatCenter(n3) - n7;
                    }
                    if (this.orientation == 0) {
                        poGraSS.fillRect(n8, n, n7, 4);
                    } else {
                        poGraSS.fillRect(this.mLeft, n8, 4, n7);
                    }
                } else if (this.orientation == 0) {
                    poGraSS.fillRect(n4, n, n5 - n4, 4);
                } else {
                    poGraSS.fillRect(this.mLeft, n4, 4, n5 - n4);
                }
            } else {
                int n = this.ax.getCatByPos(this.orientation == 0 ? this.baseDragX1 : this.baseDragY1);
                if (n > -1) {
                    this.pp[n].setVisible(true);
                    ((PPrimBase)this.pp[n]).setDragging(true);
                    this.pp[n].paint(poGraSS, this.orientation, this.m);
                }
            }
        }
        super.paintPost(poGraSS);
    }

    public String queryObject(PlotPrimitive plotPrimitive) {
        int n = this.getMarked(plotPrimitive);
        if (plotPrimitive != null) {
            if (plotPrimitive instanceof PPrimBox) {
                String string = "";
                PPrimBox pPrimBox = (PPrimBox)plotPrimitive;
                string = pPrimBox.queriedOutlier != null ? string + "Outlier: " + Tools.getDisplayableValue(pPrimBox.queriedOutlier.getValue()) : string + "lower whisker: " + Tools.getDisplayableValue(pPrimBox.lh15Value) + "\nlower hinge: " + Tools.getDisplayableValue(pPrimBox.lhValue) + "\nmedian: " + Tools.getDisplayableValue(pPrimBox.medValue) + "\nupper hinge: " + Tools.getDisplayableValue(pPrimBox.uhValue) + "\nupper whisker: " + Tools.getDisplayableValue(pPrimBox.uh15Value);
                if (this.isExtQuery) {
                    string = string + "\ncases: " + plotPrimitive.cases();
                    if (this.isMouseOnHilite || n > 0) {
                        string = string + "\nhighlighted: " + n + " (" + Tools.getDisplayableValue(100.0 * (double)n / (double)plotPrimitive.cases(), 2) + "%)";
                    }
                }
                if (!this.isExtQuery && (this.isMouseOnHilite || n > 0)) {
                    string = string + "\n\nhighlighted: " + Tools.getDisplayableValue(100.0 * (double)n / (double)plotPrimitive.cases(), 2) + "%";
                }
                return string;
            }
            if (plotPrimitive instanceof PPrimPolygon) {
                int[] nArray;
                String string = "";
                int[] nArray2 = nArray = this.orientation == 0 ? ((PPrimPolygon)plotPrimitive).pg.ypoints : ((PPrimPolygon)plotPrimitive).pg.xpoints;
                if (this.isExtQuery) {
                    for (int i = 0; i < this.v.length; ++i) {
                        string = string + this.v[i].getName() + ": ";
                        string = this.v[i].isCat() ? string + this.v[i].getCatAt((int)(this.commonScale || i == 0 ? this.ay : this.opAy[i - 1]).getValueForPos(nArray[i])) + "\n" : string + Tools.getDisplayableValue((this.commonScale || i == 0 ? this.ay : this.opAy[i - 1]).getValueForPos(nArray[i])) + "\n";
                    }
                } else {
                    int n2 = this.ax.getCatByPos(this.orientation == 0 ? this.mouseX : this.mouseY);
                    int n3 = this.ax.getCatSeqIndex(n2);
                    string = string + this.v[n2].getName() + ": ";
                    string = this.v[n2].isCat() ? string + this.v[n2].getCatAt((int)(this.commonScale || n3 == 0 ? this.ay : this.opAy[n3 - 1]).getValueForPos(nArray[n3])) + "\n" : string + Tools.getDisplayableValue((this.commonScale || n2 == 0 ? this.ay : this.opAy[n2 - 1]).getValueForPos(nArray[n3]));
                }
                return string;
            }
        }
        return null;
    }

    public String queryPlotSpace() {
        switch (this.type) {
            case 1: {
                return "Boxplot" + (this.cv != null ? "(" + this.cv.getName() + ")" : "") + (this.v != null ? "\nvariables: " + this.v.length : "");
            }
            case 0: {
                int n = this.v != null && this.v[0] != null ? this.v[0].size() : -1;
                return "PCP" + (this.cv != null ? "(" + this.cv.getName() + ")" : "") + (n != -1 ? "\nsize: " + this.v[0].size() : "") + "\nselected: " + this.m.marked() + (n > 0 ? " (" + Tools.getDisplayableValue(100.0 * ((double)this.m.marked() / (double)n), 2) + " %)" : "") + (this.v != null ? "\nvariables: " + this.v.length : "");
            }
        }
        return super.queryPlotSpace();
    }

    public void rotate(int n) {
        super.rotate(n);
        this.updateMargins();
    }

    public void paintSelected(PoGraSS poGraSS) {
        block15: {
            int n;
            if (this.type != 1 && this.type != 2 || this.markStats == null) break block15;
            int[][] nArrayArray = new int[this.v.length][];
            for (n = 0; n < this.v.length; ++n) {
                nArrayArray[n] = this.v[n].getRanked(this.m, -1);
            }
            if (this.vsCat) {
                if (nArrayArray[0] == null) {
                    return;
                }
                for (n = 0; n < this.cs; ++n) {
                    this.rs[this.cs + 1 + n] = 0;
                }
                for (n = 0; n < nArrayArray[0].length; ++n) {
                    int n2 = this.cv.getCatIndex(this.cv.at(nArrayArray[0][n]));
                    if (n2 < 0) {
                        n2 = this.cs;
                    }
                    this.rk[n2][this.rs[n2 += this.cs + 1]] = nArrayArray[0][n];
                    int n3 = n2;
                    this.rs[n3] = this.rs[n3] + 1;
                }
                for (n = this.cs + 1; n < 2 * this.cs + 1; ++n) {
                    this.oss[n].update(this.v[0], this.rk[n], this.rs[n]);
                }
            } else {
                for (n = 0; n < this.v.length; ++n) {
                    if (nArrayArray[n] != null) {
                        this.markStats[n].update(this.v[n], nArrayArray[n]);
                        continue;
                    }
                    this.markStats[n].update(this.v[n], new int[0]);
                }
            }
            for (n = 0; n < this.boxes.size(); ++n) {
                PPrimBox pPrimBox = (PPrimBox)this.boxes.get(n);
                if (this.markStats[n].lastTop == 0) {
                    pPrimBox.slastR = null;
                    continue;
                }
                Axis axis = this.commonScale || n == 0 || this.vsCat ? this.ay : this.opAy[n - 1];
                pPrimBox.sx = pPrimBox.x + pPrimBox.w / 4;
                pPrimBox.sw = pPrimBox.w / 2;
                pPrimBox.smed = axis.getValuePos(this.markStats[n].med);
                pPrimBox.slh = axis.getValuePos(this.markStats[n].lh);
                pPrimBox.suh = axis.getValuePos(this.markStats[n].uh);
                pPrimBox.slh15 = axis.getValuePos(this.markStats[n].lh15);
                pPrimBox.suh15 = axis.getValuePos(this.markStats[n].uh15);
                pPrimBox.slh3 = this.markStats[n].lh3;
                pPrimBox.suh3 = this.markStats[n].uh3;
                pPrimBox.slowEdge = this.markStats[n].lowEdge;
                int n4 = this.vsCat ? 0 : n;
                pPrimBox.sminValue = this.v[n4].atD(nArrayArray[n4][0]);
                pPrimBox.smaxValue = this.v[n4].atD(nArrayArray[n4][nArrayArray[n4].length - 1]);
                if (this.markStats[n].lastR != null) {
                    pPrimBox.slastR = new double[this.markStats[n].lastR.length];
                    pPrimBox.svalPos = new int[this.markStats[n].lastR.length];
                    for (int i = 0; i < pPrimBox.slastR.length; ++i) {
                        pPrimBox.slastR[i] = this.v[this.vsCat ? 0 : n].atF(this.markStats[n].lastR[i]);
                        pPrimBox.svalPos[i] = axis.getValuePos(pPrimBox.slastR[i]);
                    }
                } else {
                    pPrimBox.slastR = null;
                    pPrimBox.svalPos = null;
                }
                pPrimBox.slastTop = this.markStats[n].lastTop;
                pPrimBox.shighEdge = this.markStats[n].highEdge;
            }
        }
        super.paintSelected(poGraSS);
    }

    private void initOss(SVar[] sVarArray) {
        if (sVarArray.length == 1) {
            this.valid = this.v[0] != null && !this.v[0].isCat() && this.v[0].isNum();
            if (this.valid) {
                this.OSdata = new OrdStats();
                int[] nArray = this.v[0].getRanked();
                this.OSdata.update(this.v[0], nArray);
            }
        } else {
            this.oss = new OrdStats[this.v.length];
            for (int i = 0; i < this.v.length; ++i) {
                if (this.v[i] != null && !this.v[i].isCat() && this.v[i].isNum()) {
                    this.valid = true;
                }
                if (!this.valid) continue;
                this.oss[i] = new OrdStats();
                int[] nArray = this.v[i].getRanked();
                this.oss[i].update(this.v[i], nArray);
            }
        }
    }

    private PPrimCircle createInvisiblePoint(int n, int n2, int n3) {
        PPrimCircle pPrimCircle = new PPrimCircle();
        pPrimCircle.x = this.orientation == 0 ? n : n2;
        pPrimCircle.y = this.orientation == 0 ? n2 : n;
        pPrimCircle.diam = 1;
        pPrimCircle.ref = new int[]{n3};
        pPrimCircle.setVisible(false);
        pPrimCircle.queryable = false;
        pPrimCircle.fillColor = pPrimCircle.borderColor;
        return pPrimCircle;
    }

    private void sortAxesBy(double[] dArray) {
        int[] nArray = Tools.sortDoublesIndex(dArray);
        this.ignoreNotifications = true;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.ax.moveCat(nArray[i], nArray.length - i);
        }
        this.updateObjects();
        this.ignoreNotifications = false;
        this.setUpdateRoot(0);
        this.repaint();
    }

    private void sortAxesBy(int[] nArray) {
        int[] nArray2 = Tools.sortIntegersIndex(nArray);
        this.ignoreNotifications = true;
        for (int i = nArray2.length - 1; i >= 0; --i) {
            this.ax.moveCat(nArray2[i], nArray2.length - i);
        }
        this.updateObjects();
        this.ignoreNotifications = false;
        this.setUpdateRoot(0);
        this.repaint();
    }

    private void sortAxes(boolean bl) {
        if (this.type != 1) {
            return;
        }
        int n = this.pp.length - this.invisiblePoints.size();
        int[] nArray = new int[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.getMarked(i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.getCount(i);
            }
        }
        this.sortAxesBy(nArray);
    }

    private int getMarked(int n) {
        return (int)Math.round((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1));
    }

    private int getMarked(PlotPrimitive plotPrimitive) {
        if (plotPrimitive != null) {
            return (int)Math.round((double)plotPrimitive.cases() * plotPrimitive.getMarkedProportion(this.m, -1));
        }
        return -1;
    }

    private int getCount(int n) {
        return this.pp[n].cases();
    }

    protected Axis getMouseOverAxis(int n, int n2) {
        if (this.axcoordX == null || this.axcoordY == null) {
            return null;
        }
        if (n >= this.axcoordX[0] - 2 && n <= this.axcoordX[1] + 2 && n2 >= this.axcoordY[0] - 2 && n2 <= this.axcoordY[1] + 2) {
            return this.ax;
        }
        for (int i = 0; i < this.v.length; ++i) {
            if (n < this.aycoordX[i][0] - 2 || n > this.aycoordX[i][1] + 2 || n2 < this.aycoordY[i][0] - 2 || n2 > this.aycoordY[i][1] + 2) continue;
            return i == 0 ? this.ay : this.opAy[i - 1];
        }
        return null;
    }

    protected String getAxisQuery(int n, int n2) {
        Axis axis = this.getMouseOverAxis(n, n2);
        if (axis == null) {
            return null;
        }
        return "axis name: " + axis.getVariable().getName();
    }

    protected void resetAxesCoord() {
        int n;
        this.axcoordY = new int[2];
        this.axcoordX = new int[2];
        this.aycoordY = new int[this.v.length][2];
        this.aycoordX = new int[this.v.length][2];
        for (n = 0; n < this.axcoordY.length; ++n) {
            this.axcoordY[n] = -256;
            this.axcoordX[n] = -256;
        }
        for (n = 0; n < this.aycoordY.length; ++n) {
            for (int i = 0; i < this.aycoordY[n].length; ++i) {
                this.aycoordY[n][i] = -256;
                this.aycoordX[n][i] = -256;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.type == 1 || this.type == 2) {
            int n = this.ax.getCatByPos(this.orientation == 0 ? this.baseDragX1 : this.baseDragY1);
            if (this.baseDrag && this.moveDrag && n > -1) {
                if (this.orientation == 0) {
                    ((PPrimBase)this.pp[n]).moveX(mouseEvent.getX() - this.boxwidth / 2);
                } else {
                    ((PPrimBase)this.pp[n]).moveY(mouseEvent.getY() - this.boxwidth / 2);
                }
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
    }

    private void updateSortingMenus() {
        boolean bl = this.type == 1 && this.vsCat;
        this.MIsortByCount.setEnabled(bl);
        this.MIsortByMarked.setEnabled(bl);
        this.MIsortByMarkedRel.setEnabled(bl);
        this.MIsortByMedian.setEnabled(bl);
        this.MIsortByMax.setEnabled(bl);
        this.MIsortByMin.setEnabled(bl);
        this.MIsortByMarkedMedian.setEnabled(bl);
        this.MIsortByMarkedMax.setEnabled(bl);
        this.MIsortByMarkedMin.setEnabled(bl);
    }

    private void initBoxes(int n) {
        int n2;
        int n3;
        this.boxes.clear();
        this.invisiblePoints.clear();
        if (!this.vsCat) {
            int n4;
            this.invisiblePoints.ensureCapacity(this.v.length * this.v[0].size());
            for (n4 = 0; n4 < this.v.length; ++n4) {
                int n5 = this.getAxCatPos(n4);
                Axis axis = this.commonScale ? this.ay : (n4 == 0 ? this.ay : this.opAy[n4 - 1]);
                for (n3 = 0; n3 < this.v[n4].size(); ++n3) {
                    n2 = axis.getValuePos(this.v[n4].atD(n3));
                    this.invisiblePoints.add(this.createInvisiblePoint(n5, n2, n3));
                }
            }
            this.pp = new PlotPrimitive[this.v.length + this.invisiblePoints.size() + n];
            this.markStats = new OrdStats[this.v.length];
            for (n4 = 0; n4 < this.v.length; ++n4) {
                this.pp[n4] = this.createBox(this.v.length == 1 ? this.OSdata : this.oss[n4], this.getAxCasePos(n4) - this.boxwidth / 2, this.boxwidth, n4);
                this.boxes.add(this.pp[n4]);
                PPrimBase pPrimBase = (PPrimBase)this.pp[n4];
                pPrimBase.ref = this.v[n4].getRanked();
                pPrimBase.performAlphaBlending = false;
                this.markStats[n4] = new OrdStats();
            }
            for (n4 = this.v.length; n4 < this.pp.length - n; ++n4) {
                this.pp[n4] = (PlotPrimitive)this.invisiblePoints.get(n4 - this.v.length);
            }
        } else {
            int n6;
            ArrayList arrayList = new ArrayList(this.v[0].size() + 10);
            for (n6 = 0; n6 < this.cs; ++n6) {
                PPrimBox pPrimBox = this.createBox(this.oss[n6], this.getAxCasePos(n6) - this.boxwidth / 2, this.boxwidth, 0);
                pPrimBox.ref = this.rk[n6];
                pPrimBox.performAlphaBlending = false;
                this.boxes.add(pPrimBox);
            }
            this.invisiblePoints.ensureCapacity(this.v[0].size());
            for (n6 = 0; n6 < this.cs; ++n6) {
                int n7 = this.getAxCasePos(n6);
                for (n3 = 0; n3 < this.rk[n6].length; ++n3) {
                    n2 = this.ay.getValuePos(this.v[0].atD(this.rk[n6][n3]));
                    this.invisiblePoints.add(this.createInvisiblePoint(n7, n2, this.rk[n6][n3]));
                }
            }
            arrayList.addAll(this.boxes);
            arrayList.addAll(this.invisiblePoints);
            this.pp = new PlotPrimitive[arrayList.size()];
            arrayList.toArray(this.pp);
            this.markStats = new OrdStats[this.boxes.size()];
            System.arraycopy(this.oss, this.cs + 1, this.markStats, 0, this.cs);
        }
        int n8 = this.invisiblePoints.size();
        for (int i = 0; i < this.pp.length - n8; ++i) {
            if (this.pp[i] instanceof PPrimBox) {
                ((PPrimBox)this.pp[i]).slastR = null;
            }
            this.setColors((PPrimBase)this.pp[i]);
        }
    }

    private void initPolylines(int n) {
        int n2;
        this.polylines.clear();
        int[][] nArray = new int[this.v[0].size()][this.v.length];
        int[][] nArray2 = new int[this.v[0].size()][this.v.length];
        int[][] nArrayArray = new int[this.v[0].size()][];
        int[] nArray3 = new int[this.v.length + 1];
        for (n2 = 0; n2 < this.v[0].size(); ++n2) {
            int n3 = 0;
            for (int i = 0; i < this.v.length; ++i) {
                nArray[n2][this.ax.getCatSeqIndex((int)i)] = this.getAxCatPos(i);
                nArray2[n2][this.ax.getCatSeqIndex((int)i)] = this.v[i].isCat() ? (this.commonScale || i == 0 ? this.ay : this.opAy[i - 1]).getValuePos(this.v[i].getCatIndex(n2)) : (this.commonScale || i == 0 ? this.ay : this.opAy[i - 1]).getValuePos(this.v[i].atD(n2));
                if ((this.drawHidden || !this.m.at(n2)) && this.v[i].at(n2) != null) continue;
                nArray3[n3++] = i;
            }
            if (n3 <= 0) continue;
            nArrayArray[n2] = new int[n3];
            System.arraycopy(nArray3, 0, nArrayArray[n2], 0, n3);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.pp[n2 + n] = new PPrimPolygon();
            this.polylines.add(this.pp[n2 + n]);
            ((PPrimPolygon)this.pp[n2 + n]).pg = this.orientation == 0 ? new Polygon(nArray[n2], nArray2[n2], nArray[n2].length) : new Polygon(nArray2[n2], nArray[n2], nArray[n2].length);
            ((PPrimPolygon)this.pp[n2 + n]).closed = false;
            ((PPrimPolygon)this.pp[n2 + n]).fill = false;
            ((PPrimPolygon)this.pp[n2 + n]).selectByCorners = !this.drawLines;
            ((PPrimPolygon)this.pp[n2 + n]).drawCorners = this.drawPoints;
            ((PPrimPolygon)this.pp[n2 + n]).ref = new int[]{n2};
            ((PPrimPolygon)this.pp[n2 + n]).setNodeSize(this.nodeSize);
            ((PPrimPolygon)this.pp[n2 + n]).drawBorder = this.drawLines;
            ((PPrimPolygon)this.pp[n2 + n]).showInvisibleLines = this.drawNAlines;
            this.setColors((PPrimBase)this.pp[n2 + n]);
            boolean[] blArray = new boolean[nArray[n2].length];
            boolean[] blArray2 = new boolean[nArray[n2].length];
            if (nArrayArray[n2] != null) {
                int n4;
                boolean[] blArray3 = new boolean[nArray[n2].length];
                for (n4 = 0; n4 < nArrayArray[n2].length; ++n4) {
                    blArray[nArrayArray[n2][n4]] = true;
                    if (nArrayArray[n2][n4] > 0) {
                        blArray[nArrayArray[n2][n4] - 1] = true;
                    }
                    blArray3[nArrayArray[n2][n4]] = true;
                }
                ((PPrimPolygon)this.pp[n2 + n]).noDotsAt = blArray3;
                for (n4 = 0; n4 < nArrayArray[n2 + n].length - 1; ++n4) {
                    if (nArrayArray[n2][n4 + 1] - nArrayArray[n2][n4] != 2) continue;
                    blArray2[nArrayArray[n2][n4] + 1] = true;
                }
                if (nArrayArray[n2][0] == 1) {
                    blArray2[0] = true;
                }
                if (nArrayArray[n2][nArrayArray[n2].length - 1] == blArray2.length - 2) {
                    blArray2[blArray2.length - 1] = true;
                }
            }
            ((PPrimPolygon)this.pp[n2 + n]).invisibleLines = blArray;
            ((PPrimPolygon)this.pp[n2 + n]).setGapDots(blArray2);
        }
    }
}

