/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.lang.reflect.Array;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !array[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static void print(double[] v) {
        System.out.print("[");
        for (int i = 0; i < v.length; ++i) {
            System.out.print(" " + v[i]);
        }
        System.out.println(" ]");
    }

    public static void print(int[] v) {
        System.out.print("[");
        for (int i = 0; i < v.length; ++i) {
            System.out.print(" " + v[i]);
        }
        System.out.println(" ]");
    }

    public static String toString(int[] v) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            buf.append(v[i]);
            if (i >= v.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String toString(double[] v) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            buf.append(v[i]);
            if (i >= v.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String toString(Object[] v) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            buf.append(v[i]);
            if (i >= v.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static int[] extend(int[] a, int additional) {
        int[] ret = new int[a.length + additional];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    public static double[] extend(double[] a, int additional) {
        double[] ret = new double[a.length + additional];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    public static int[] append(int[] a1, int[] a2) {
        int[] ret = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, ret, 0, a1.length);
        System.arraycopy(a2, 0, ret, a1.length, a2.length);
        return ret;
    }

    public static double[] append(double[] a1, double[] a2) {
        double[] ret = new double[a1.length + a2.length];
        System.arraycopy(a1, 0, ret, 0, a1.length);
        System.arraycopy(a2, 0, ret, a1.length, a2.length);
        return ret;
    }

    public static int[] append(int[] v, int elem) {
        int[] ret = new int[v.length + 1];
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static boolean[] append(boolean[] v, boolean elem) {
        boolean[] ret = new boolean[v.length + 1];
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static Object[] append(Object[] v, Object elem) {
        Object[] ret = (Object[])Array.newInstance(v.getClass().getComponentType(), v.length + 1);
        System.arraycopy(v, 0, ret, 0, v.length);
        ret[v.length] = elem;
        return ret;
    }

    public static double count(int[] sampled, int val) {
        int count = 0;
        for (int i = 0; i < sampled.length; ++i) {
            if (sampled[i] != val) continue;
            ++count;
        }
        return count;
    }

    public static int argmax(double[] elems) {
        int bestIdx = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < elems.length; ++i) {
            double elem = elems[i];
            if (!(elem > max)) continue;
            max = elem;
            bestIdx = i;
        }
        return bestIdx;
    }

    public static boolean equals(boolean[][] m1, boolean[][] m2) {
        if (m1.length != m2.length) {
            return false;
        }
        for (int i = 0; i < m1.length; ++i) {
            if (m1[i].length != m2[i].length) {
                return false;
            }
            for (int j = 0; j < m1[i].length; ++j) {
                boolean b1 = m1[i][j];
                boolean b2 = m2[i][j];
                if (b1 == b2) continue;
                return false;
            }
        }
        return true;
    }
}

