/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.cnf;

import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.cnf.ALogicTree;
import choco.kernel.model.variables.integer.IntegerVariable;

public final class Literal
extends ALogicTree
implements Comparable<Literal> {
    private IntegerVariable var;
    private IntegerVariable[] varAsArray;

    protected Literal(IntegerVariable var, ALogicTree.Type type) {
        super(type);
        if (!var.isBoolean()) {
            throw new ModelException("Literal cannot be declared with non boolean variable! (" + var.pretty() + ")");
        }
        this.var = var;
        this.varAsArray = new IntegerVariable[]{var};
    }

    public static Literal pos(IntegerVariable var) {
        return new Literal(var, ALogicTree.Type.POSITIVE);
    }

    public static Literal[] pos(IntegerVariable[] vars) {
        Literal[] lits = new Literal[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            lits[i] = new Literal(vars[i], ALogicTree.Type.POSITIVE);
        }
        return lits;
    }

    public static Literal neg(IntegerVariable var) {
        return new Literal(var, ALogicTree.Type.NEGATIVE);
    }

    public static Literal[] neg(IntegerVariable[] vars) {
        Literal[] lits = new Literal[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            lits[i] = new Literal(vars[i], ALogicTree.Type.NEGATIVE);
        }
        return lits;
    }

    @Override
    public boolean is(ALogicTree.Operator op) {
        return false;
    }

    @Override
    public boolean isNot() {
        return false;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    int getNbChildren() {
        return 0;
    }

    @Override
    public boolean hasOrChild() {
        return false;
    }

    @Override
    public boolean hasAndChild() {
        return false;
    }

    @Override
    public void addChild(ALogicTree child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChild(ALogicTree child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ALogicTree[] getChildren() {
        return null;
    }

    @Override
    public ALogicTree getAndChild() {
        return null;
    }

    @Override
    public ALogicTree getChildBut(ALogicTree child) {
        return null;
    }

    @Override
    void deny() {
        this.type = ALogicTree.Type.flip(this.type);
    }

    @Override
    void flip() {
        this.type = ALogicTree.Type.flip(this.type);
    }

    public String toString() {
        return (ALogicTree.Type.POSITIVE.equals((Object)this.type) ? "" : "not ") + this.var.getName();
    }

    @Override
    public int compareTo(Literal o) {
        if (this.type.equals((Object)o.type)) {
            return 0;
        }
        if (ALogicTree.Type.POSITIVE.equals((Object)this.type)) {
            return -1;
        }
        return 1;
    }

    @Override
    public Literal clone() throws CloneNotSupportedException {
        Literal lit = (Literal)super.clone();
        lit.var = this.var;
        lit.type = this.type;
        return lit;
    }

    @Override
    public IntegerVariable[] flattenBoolVar() {
        return this.varAsArray;
    }

    @Override
    public int getNbPositiveLiterals() {
        return ALogicTree.Type.POSITIVE.equals((Object)this.type) ? 1 : 0;
    }
}

