/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Process;

import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.PathResult;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.cluster.TravelTimeResult;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.path.RouteSequence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Collection;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.Process.R5Process;
import org.ipea.r5r.R5.R5TravelTimeComputer;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.ipea.r5r.Utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravelTimeMatrixComputer
extends R5Process {
    private static final Logger LOG = LoggerFactory.getLogger(TravelTimeMatrixComputer.class);

    public TravelTimeMatrixComputer(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    protected RDataFrame runProcess(int index) throws ParseException {
        RegionalTask request = this.buildRequest(index);
        R5TravelTimeComputer computer = new R5TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = this.buildDataFrameStructure(this.fromIds[index], 10);
        this.populateDataFrame(travelTimeResults, travelTimesTable);
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable;
        }
        return null;
    }

    private void populateDataFrame(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        if (this.routingProperties.expandedTravelTimes) {
            this.populateExpandedResults(travelTimeResults, travelTimesTable);
        } else {
            this.populateRegularResults(travelTimeResults, travelTimesTable);
        }
    }

    private void populateRegularResults(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        for (int destination = 0; destination < travelTimeResults.travelTimes.nPoints; ++destination) {
            if (travelTimeResults.travelTimes.getValues()[0][destination] > this.maxTripDuration) continue;
            travelTimesTable.append();
            travelTimesTable.set("to_id", this.toIds[destination]);
            for (int p = 0; p < this.routingProperties.percentiles.length; ++p) {
                int tt = travelTimeResults.travelTimes.getValues()[p][destination];
                String ps = String.format("%02d", this.routingProperties.percentiles[p]);
                if (tt > this.maxTripDuration) continue;
                travelTimesTable.set("travel_time_p" + ps, tt);
            }
        }
    }

    private void populateExpandedResults(OneOriginResult travelTimeResults, RDataFrame travelTimesTable) {
        Multimap<Integer, PathBreakdown>[] pathBreakdown = this.extractPathResults(travelTimeResults.paths, travelTimeResults.travelTimes);
        for (int destination = 0; destination < travelTimeResults.travelTimes.nPoints; ++destination) {
            this.populateTravelTimesBreakdown(travelTimesTable, pathBreakdown, destination);
        }
    }

    private Multimap<Integer, PathBreakdown>[] extractPathResults(PathResult paths, TravelTimeResult travelTimes) {
        try {
            Field privateField = PathResult.class.getDeclaredField("iterationsForPathTemplates");
            privateField.setAccessible(true);
            Multimap[] iterationMaps = (Multimap[])privateField.get(paths);
            Multimap[] pathResults = new Multimap[this.nDestinations];
            for (int d = 0; d < this.nDestinations; ++d) {
                pathResults[d] = ArrayListMultimap.create();
                Multimap iterationMap = iterationMaps[d];
                if (iterationMap != null) {
                    for (RouteSequence routeSequence : iterationMap.keySet()) {
                        Collection iterations = iterationMap.get((Object)routeSequence);
                        int nIterations = iterations.size();
                        Preconditions.checkState((nIterations > 0 ? 1 : 0) != 0, (Object)"A path was stored without any iterations");
                        String[] path = routeSequence.detailsWithGtfsIds(this.transportNetwork.transitLayer);
                        for (PathResult.Iteration iteration : iterations) {
                            PathBreakdown breakdown = new PathBreakdown();
                            breakdown.departureTime = Utils.getTimeFromSeconds(iteration.departureTime);
                            breakdown.accessTime = routeSequence.stopSequence.access == null ? 0.0 : (double)((float)routeSequence.stopSequence.access.time / 60.0f);
                            breakdown.waitTime = (float)iteration.waitTimes.sum() / 60.0f;
                            breakdown.rideTime = routeSequence.stopSequence.rideTimesSeconds == null ? 0.0 : (double)((float)routeSequence.stopSequence.rideTimesSeconds.sum() / 60.0f);
                            breakdown.transferTime = (float)routeSequence.stopSequence.transferTime(iteration) / 60.0f;
                            breakdown.egressTime = routeSequence.stopSequence.egress == null ? 0.0 : (double)((float)routeSequence.stopSequence.egress.time / 60.0f);
                            breakdown.totalTime = (float)iteration.totalTime / 60.0f;
                            breakdown.routes = path[0];
                            int n = breakdown.nRides = routeSequence.stopSequence.rideTimesSeconds == null ? 0 : routeSequence.stopSequence.rideTimesSeconds.size();
                            if (iteration.departureTime == 0) {
                                breakdown.departureTime = "";
                                breakdown.routes = this.directModes.toString();
                            }
                            pathResults[d].put((Object)iteration.departureTime, (Object)breakdown);
                        }
                    }
                    continue;
                }
                if (travelTimes.getValues()[0][d] > this.maxTripDuration) continue;
                PathBreakdown breakdown = new PathBreakdown();
                breakdown.departureTime = "";
                breakdown.routes = this.directModes.toString();
                breakdown.totalTime = travelTimes.getValues()[0][d];
                pathResults[d].put((Object)0, (Object)breakdown);
            }
            return pathResults;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void populateTravelTimesBreakdown(RDataFrame travelTimesTable, Multimap<Integer, PathBreakdown>[] pathBreakdown, int destination) {
        if (this.routingProperties.expandedTravelTimes & pathBreakdown != null && !pathBreakdown[destination].isEmpty()) {
            for (int departure = this.secondsFromMidnight; departure < this.secondsFromMidnight + this.routingProperties.timeWindowSize * 60; departure += 60) {
                PathBreakdown directPath;
                Collection pathCollection = pathBreakdown[destination].get((Object)departure);
                int monteCarloDrawsForPath = 0;
                for (PathBreakdown path : pathCollection) {
                    this.addPathToDataframe(travelTimesTable, destination, ++monteCarloDrawsForPath, path);
                }
                int monteCarloDrawsPerMinute = this.transportNetwork.transitLayer.hasFrequencies ? this.routingProperties.numberOfMonteCarloDraws / this.routingProperties.timeWindowSize : 1;
                if (monteCarloDrawsForPath >= monteCarloDrawsPerMinute) continue;
                Collection directPaths = pathBreakdown[destination].get((Object)0);
                if (!directPaths.isEmpty()) {
                    directPath = (PathBreakdown)directPaths.iterator().next();
                } else {
                    directPath = new PathBreakdown();
                    directPath.unreachable();
                }
                for (int mc = monteCarloDrawsForPath + 1; mc <= monteCarloDrawsPerMinute; ++mc) {
                    directPath.departureTime = Utils.getTimeFromSeconds(departure);
                    this.addPathToDataframe(travelTimesTable, destination, mc, directPath);
                }
            }
        }
    }

    private void addPathToDataframe(RDataFrame travelTimesTable, int destination, int monteCarloDrawsForPath, PathBreakdown path) {
        travelTimesTable.append();
        travelTimesTable.set("to_id", this.toIds[destination]);
        travelTimesTable.set("draw_number", monteCarloDrawsForPath);
        travelTimesTable.set("departure_time", path.departureTime);
        travelTimesTable.set("routes", path.routes);
        travelTimesTable.set("total_time", path.getCombinedTravelTime() > 0.0 ? path.getCombinedTravelTime() : path.getTotalTime());
        if (this.routingProperties.travelTimesBreakdown) {
            travelTimesTable.set("access_time", path.getAccessTime());
            travelTimesTable.set("wait_time", path.getWaitTime());
            travelTimesTable.set("ride_time", path.getRideTime());
            travelTimesTable.set("transfer_time", path.getTransferTime());
            travelTimesTable.set("egress_time", path.getEgressTime());
            travelTimesTable.set("n_rides", path.nRides);
        }
    }

    @Override
    protected RDataFrame buildDataFrameStructure(String fromId, int nRows) {
        RDataFrame travelTimesTable = new RDataFrame(nRows);
        travelTimesTable.addStringColumn("from_id", fromId);
        travelTimesTable.addStringColumn("to_id", "");
        if (!this.routingProperties.expandedTravelTimes) {
            for (int p : this.routingProperties.percentiles) {
                String ps = String.format("%02d", p);
                travelTimesTable.addIntegerColumn("travel_time_p" + ps, Integer.MAX_VALUE);
            }
        } else {
            travelTimesTable.addStringColumn("departure_time", "");
            travelTimesTable.addIntegerColumn("draw_number", 0);
            if (this.routingProperties.travelTimesBreakdown) {
                travelTimesTable.addDoubleColumn("access_time", 0.0);
                travelTimesTable.addDoubleColumn("wait_time", 0.0);
                travelTimesTable.addDoubleColumn("ride_time", 0.0);
                travelTimesTable.addDoubleColumn("transfer_time", 0.0);
                travelTimesTable.addDoubleColumn("egress_time", 0.0);
            }
            travelTimesTable.addStringColumn("routes", "");
            if (this.routingProperties.travelTimesBreakdown) {
                travelTimesTable.addIntegerColumn("n_rides", 0);
            }
            travelTimesTable.addDoubleColumn("total_time", 0.0);
        }
        return travelTimesTable;
    }

    @Override
    protected RegionalTask buildRequest(int index) throws ParseException {
        RegionalTask request = super.buildRequest(index);
        request.percentiles = this.routingProperties.percentiles;
        request.includePathResults = this.routingProperties.expandedTravelTimes;
        request.destinationPointSetKeys = this.opportunities;
        request.destinationPointSets = this.destinationPoints;
        return request;
    }

    class PathBreakdown {
        String departureTime;
        double accessTime;
        double waitTime;
        double rideTime;
        double transferTime;
        double egressTime;
        double totalTime;
        String routes;
        int nRides;

        PathBreakdown() {
        }

        public double roundTo1Place(double value) {
            return (double)Math.round(value * 10.0) / 10.0;
        }

        public double getAccessTime() {
            return this.roundTo1Place(this.accessTime);
        }

        public double getWaitTime() {
            return this.roundTo1Place(this.waitTime);
        }

        public double getRideTime() {
            return this.roundTo1Place(this.rideTime);
        }

        public double getTransferTime() {
            return this.roundTo1Place(this.transferTime);
        }

        public double getEgressTime() {
            return this.roundTo1Place(this.egressTime);
        }

        public double getTotalTime() {
            return this.roundTo1Place(this.totalTime);
        }

        public double getCombinedTravelTime() {
            return this.roundTo1Place(this.getAccessTime() + this.getWaitTime() + this.getRideTime() + this.getTransferTime() + this.getEgressTime());
        }

        public void unreachable() {
            this.departureTime = "";
            this.accessTime = 0.0;
            this.waitTime = 0.0;
            this.rideTime = 0.0;
            this.transferTime = 0.0;
            this.egressTime = 0.0;
            this.totalTime = 2.147483647E9;
            this.routes = TravelTimeMatrixComputer.this.directModes.toString();
            this.nRides = 0;
        }
    }
}

