/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class ChiSquareQF
extends AbstractQFStatisticBased {
    @Override
    public String getID() {
        return "ChiSquareQF";
    }

    @Override
    public String getName() {
        return "Chi-Square";
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        if (statistics == null || !statistics.isBinary()) {
            throw new IllegalArgumentException("Statistics for subgroup were computed before or are not binary!");
        }
        double value = SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)statistics);
        if (Double.isNaN(value)) {
            value = Double.NEGATIVE_INFINITY;
        }
        return value;
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }

    @Override
    public ChiSquareQF clone() {
        return new ChiSquareQF();
    }
}

