/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.util.Taxon;
import java.util.Stack;
import jebl.util.FixedBitSet;

public interface AlloppNode {
    public int nofChildren();

    public AlloppNode getChild(int var1);

    public AlloppNode getAnc();

    public Taxon getTaxon();

    public double getHeight();

    public FixedBitSet getUnion();

    public void setChild(int var1, AlloppNode var2);

    public void setAnc(AlloppNode var1);

    public void setTaxon(String var1);

    public void setHeight(double var1);

    public void setUnion(FixedBitSet var1);

    public void addChildren(AlloppNode var1, AlloppNode var2);

    public String asText(int var1);

    public void fillinUnionsInSubtree(int var1);

    public AlloppNode nodeOfUnionInSubtree(FixedBitSet var1);

    public static abstract class Abstract
    implements AlloppNode {
        @Override
        public void fillinUnionsInSubtree(int n) {
            if (this.nofChildren() > 0) {
                this.getChild(0).fillinUnionsInSubtree(n);
                this.getChild(1).fillinUnionsInSubtree(n);
                FixedBitSet fixedBitSet = new FixedBitSet(n);
                fixedBitSet.union(this.getChild(0).getUnion());
                fixedBitSet.union(this.getChild(1).getUnion());
                this.setUnion(fixedBitSet);
            }
        }

        @Override
        public AlloppNode nodeOfUnionInSubtree(FixedBitSet fixedBitSet) {
            if (this.nofChildren() == 0) {
                return this;
            }
            if (fixedBitSet.setInclusion(this.getChild(0).getUnion())) {
                return this.getChild(0).nodeOfUnionInSubtree(fixedBitSet);
            }
            if (fixedBitSet.setInclusion(this.getChild(1).getUnion())) {
                return this.getChild(1).nodeOfUnionInSubtree(fixedBitSet);
            }
            return this;
        }

        public static String subtreeAsText(AlloppNode alloppNode, String string, Stack<Integer> stack, int n, String string2) {
            int n2;
            Integer[] integerArray = stack.toArray(new Integer[stack.size()]);
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append("  ");
            }
            for (n2 = 0; n2 < integerArray.length; ++n2) {
                stringBuffer.replace(2 * integerArray[n2], 2 * integerArray[n2] + 1, "|");
            }
            if (string2.length() > 0) {
                stringBuffer.replace(stringBuffer.length() - string2.length(), stringBuffer.length(), string2);
            }
            string = string + stringBuffer;
            string = string + alloppNode.asText(stringBuffer.length());
            string = string + System.getProperty("line.separator");
            String string3 = "";
            if (alloppNode.nofChildren() > 0) {
                stack.push(n);
                string3 = string3 + Abstract.subtreeAsText(alloppNode.getChild(0), "", stack, n + 1, "-");
                stack.pop();
                string3 = string3 + Abstract.subtreeAsText(alloppNode.getChild(1), "", stack, n + 1, "`-");
            }
            return string + string3;
        }
    }
}

