/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaTableHeaderBorder;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class QuaquaTableHeaderUI
extends BasicTableHeaderUI {
    protected TableColumnModelListener columnModelListener;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTableHeaderUI();
    }

    public void installDefaults() {
        super.installDefaults();
        if (this.header.getDefaultRenderer() instanceof JLabel) {
            ((JLabel)((Object)this.header.getDefaultRenderer())).setHorizontalAlignment(10);
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
            Border cellBorder = UIManager.getBorder("TableHeader.cellBorder");
            if (cellBorder instanceof QuaquaTableHeaderBorder) {
                QuaquaTableHeaderBorder qthb = (QuaquaTableHeaderBorder)cellBorder;
                qthb.setColumnIndex(-1);
            }
            if (cellBorder instanceof BackgroundBorder) {
                cellBorder = ((BackgroundBorder)cellBorder).getBackgroundBorder();
            }
            if (cellBorder != null) {
                cellBorder.paintBorder(this.header, g, cMax, 0, this.header.getWidth() - cMax, this.header.getHeight());
            }
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    protected void installListeners() {
        this.columnModelListener = this.createColumnModelListener();
        this.header.getColumnModel().addColumnModelListener(this.columnModelListener);
        super.installListeners();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.header.getColumnModel().removeColumnModelListener(this.columnModelListener);
        this.columnModelListener = null;
    }

    private TableColumnModelListener createColumnModelListener() {
        return new ColumnHandler();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        if (component instanceof JComponent && ((JComponent)component).getBorder() instanceof QuaquaTableHeaderBorder) {
            QuaquaTableHeaderBorder thb = (QuaquaTableHeaderBorder)((JComponent)component).getBorder();
            thb.setColumnIndex(columnIndex);
            boolean isSorted = false;
            Object rowSorter = Methods.invokeGetter((Object)this.header.getTable(), "getRowSorter", null);
            List sortKeys = (List)(rowSorter == null ? null : Methods.invokeGetter(rowSorter, "getSortKeys", null));
            Object sortKey = sortKeys == null || sortKeys.isEmpty() ? null : sortKeys.get(0);
            int sortedColumnIndex = sortKey == null ? -1 : Methods.invokeGetter(sortKey, "getColumn", -1);
            isSorted = sortedColumnIndex == columnIndex;
            thb.setSorted(isSorted);
            thb.setOnActiveWindow(QuaquaUtilities.isOnActiveWindow(this.header.getTable()));
            this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            thb.setSorted(false);
            thb.setOnActiveWindow(true);
        } else {
            this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    private Dimension createHeaderSize(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    private int getHeaderHeight() {
        int height = 0;
        int emptyHeight = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            Border b;
            TableColumn aColumn = columnModel.getColumn(column);
            if (aColumn.getHeaderRenderer() == null && accomodatedDefault) continue;
            Component comp = this.getHeaderRenderer(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (comp instanceof JComponent && (b = ((JComponent)comp).getBorder()) != null && b instanceof UIResource) {
                Insets insets = b.getBorderInsets(comp);
                emptyHeight = Math.max(emptyHeight, insets.top + insets.bottom);
            }
            if (rendererHeight <= emptyHeight) continue;
            accomodatedDefault = true;
        }
        return height <= emptyHeight ? 0 : height;
    }

    private class ColumnHandler
    implements TableColumnModelListener {
        private ColumnHandler() {
        }

        private void updateViewport() {
            JViewport viewport;
            Object property;
            JTable table = QuaquaTableHeaderUI.this.header.getTable();
            Object object = property = table == null ? null : table.getClientProperty("Quaqua.Table.style");
            if (property != null && property.equals("striped") && table.getParent() instanceof JViewport && (viewport = (JViewport)table.getParent()).getHeight() > table.getHeight()) {
                viewport.repaint(0, table.getHeight(), viewport.getWidth(), viewport.getHeight() - table.getHeight());
            }
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.updateViewport();
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.updateViewport();
        }

        public void columnMoved(TableColumnModelEvent e) {
            this.updateViewport();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.updateViewport();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            this.updateViewport();
        }
    }
}

