/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SASClientHandler {
    private static final Method GET_TIME_SERIES;
    protected static Logger logger;
    private static DataCache data;
    private static MetadataCache metadata;
    private static ObservationMetadataCache obsmetadata;

    public static String makeGetDimensions(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            List<Dimension> list = SdmxClientHandler.getDimensions(string, string2);
            for (Dimension dimension : list) {
                stringBuilder.append(dimension.getId());
                stringBuilder.append(",");
            }
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
        }
        return stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
    }

    public static int makeGetTimeSeries(String string, String string2, String string3, String string4) {
        int n = 0;
        data = null;
        metadata = null;
        obsmetadata = null;
        try {
            List list = (List)GET_TIME_SERIES.invoke(null, string, string2, string3, string4, false, null, false);
            if (!list.isEmpty()) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    n2 = portableTimeSeries.size();
                    n3 += n2;
                    n4 += portableTimeSeries.getDimensionsMap().size();
                    n4 += portableTimeSeries.getAttributesMap().size();
                    n5 += portableTimeSeries.getObsLevelAttributesNames().size() * n2;
                }
                data = new DataCache(n3);
                metadata = new MetadataCache(n4);
                obsmetadata = new ObservationMetadataCache(n5);
                int n6 = 0;
                int n7 = 0;
                n2 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    if (!portableTimeSeries.isNumeric()) {
                        logger.warning("Time Series " + portableTimeSeries.getName() + "is not numeric and will be skipped in SAS.");
                        continue;
                    }
                    String string5 = portableTimeSeries.getName();
                    for (Map.Entry<String, String> entry : portableTimeSeries.getDimensionsMap().entrySet()) {
                        metadata.setRow(n7++, string5, entry.getKey(), entry.getValue(), "DIMENSION");
                    }
                    for (Map.Entry<String, String> entry : portableTimeSeries.getAttributesMap().entrySet()) {
                        metadata.setRow(n7++, string5, entry.getKey(), entry.getValue(), "ATTRIBUTE");
                    }
                    for (BaseObservation baseObservation : portableTimeSeries) {
                        String string6 = baseObservation.getTimeslot();
                        double d = baseObservation.getValueAsDouble();
                        if (n6 > data.size()) {
                            throw new SdmxSASException("Trying to process more data than available");
                        }
                        data.setRow(n6, string5, string6, d);
                        for (String string7 : portableTimeSeries.getObsLevelAttributesNames()) {
                            obsmetadata.setRow(n2, string5, string7, baseObservation.getAttributeValue(string7), string6);
                            ++n2;
                        }
                        ++n6;
                    }
                }
                n = list.size();
            }
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
            data = null;
            metadata = null;
            n = -1;
        }
        return n;
    }

    public static String getMetaName(double d) throws SdmxSASException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getName((int)d);
        }
        throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaKey(double d) throws SdmxSASException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getKey((int)d);
        }
        throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaValue(double d) throws SdmxSASException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getValue((int)d);
        }
        throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaType(double d) throws SdmxSASException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getType((int)d);
        }
        throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static double getDataObservation(double d) throws SdmxSASException {
        if (data != null && d <= (double)data.size()) {
            return data.getObservation((int)d);
        }
        throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataTimestamp(double d) throws SdmxSASException {
        if (data != null && d <= (double)data.size()) {
            return data.getTimestamp((int)d);
        }
        throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataName(double d) throws SdmxSASException {
        if (data != null && d <= (double)data.size()) {
            return data.getName((int)d);
        }
        throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
    }

    public static int getNumberOfMeta() {
        if (metadata != null) {
            return metadata.size();
        }
        return 0;
    }

    public static int getNumberOfObsMeta() {
        if (obsmetadata != null) {
            return obsmetadata.size();
        }
        return 0;
    }

    public static int getNumberOfData() {
        if (data != null) {
            return data.size();
        }
        return 0;
    }

    public static String getObsMetaName(double d) throws SdmxSASException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getName((int)d);
        }
        throw new SdmxSASException("Observation level Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaKey(double d) throws SdmxSASException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getKey((int)d);
        }
        throw new SdmxSASException("Observation level  cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaValue(double d) throws SdmxSASException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getValue((int)d);
        }
        throw new SdmxSASException("Observation level  cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaDate(double d) throws SdmxSASException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getDate((int)d);
        }
        throw new SdmxSASException("Observation level  cache error: cache is null or index exceeds size.");
    }

    static {
        String string = System.getenv().getOrDefault("SAS_SDMX_CLIENT_HANDLER", "it.bancaditalia.oss.sdmx.client.SdmxClientHandler");
        try {
            Class<?> clazz = Class.forName(string);
            GET_TIME_SERIES = clazz.getMethod("getTimeSeries", String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            throw new ExceptionInInitializerError(exception);
        }
        logger = Configuration.getSdmxLogger();
        data = null;
        metadata = null;
        obsmetadata = null;
    }

    private static class ObservationMetadataCache {
        private static final int NAME_COL = 0;
        private static final int KEY_COL = 1;
        private static final int VALUE_COL = 2;
        private static final int DATE_COL = 3;
        String[][] data = null;

        ObservationMetadataCache(int n) {
            this.data = new String[n][4];
        }

        void setRow(int n, String string, String string2, String string3, String string4) throws SdmxSASException {
            if (this.data == null || n >= this.data.length) {
                throw new SdmxSASException("Row index exceeds metadata size");
            }
            this.data[n][0] = string;
            this.data[n][1] = string2;
            this.data[n][2] = string3;
            this.data[n][3] = string4;
        }

        String getName(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][0];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getKey(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][1];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getValue(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][2];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getDate(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][3];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        int size() {
            if (this.data != null) {
                return this.data.length;
            }
            return -1;
        }
    }

    private static class MetadataCache {
        private static final int NAME_COL = 0;
        private static final int KEY_COL = 1;
        private static final int VALUE_COL = 2;
        private static final int TYPE_COL = 3;
        String[][] data = null;

        MetadataCache(int n) {
            this.data = new String[n][4];
        }

        void setRow(int n, String string, String string2, String string3, String string4) throws SdmxSASException {
            if (this.data == null || n >= this.data.length) {
                throw new SdmxSASException("Row index exceeds metadata size");
            }
            this.data[n][0] = string;
            this.data[n][1] = string2;
            this.data[n][2] = string3;
            this.data[n][3] = string4;
        }

        String getName(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][0];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getKey(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][1];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getValue(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][2];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        String getType(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return this.data[n][3];
            }
            throw new SdmxSASException("Metadata cache error: cache is null or index exceeds size.");
        }

        int size() {
            if (this.data != null) {
                return this.data.length;
            }
            return -1;
        }
    }

    private static class DataCache {
        private static final int NAME_COL = 0;
        private static final int TIME_COL = 1;
        private static final int OBS_COL = 2;
        Object[][] data = null;

        DataCache(int n) {
            this.data = new Object[n][3];
        }

        void setRow(int n, String string, String string2, double d) throws SdmxException {
            if (this.data == null || n >= this.data.length) {
                throw new SdmxSASException("Row index exceeds data size");
            }
            this.data[n][0] = string;
            this.data[n][1] = string2;
            this.data[n][2] = new Double(d);
        }

        double getObservation(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return (Double)this.data[n][2];
            }
            throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
        }

        String getName(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return (String)this.data[n][0];
            }
            throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
        }

        String getTimestamp(int n) throws SdmxSASException {
            if (this.data != null && n < this.data.length) {
                return (String)this.data[n][1];
            }
            throw new SdmxSASException("Data cache error: cache is null or index exceeds size.");
        }

        int size() {
            if (this.data != null) {
                return this.data.length;
            }
            return -1;
        }
    }

    private static class SdmxSASException
    extends SdmxException {
        private static final long serialVersionUID = 1L;

        public SdmxSASException(String string) {
            super("SAS connector error: " + string, null);
        }
    }
}

