/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous.hmc;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.hmc.TreePrecisionColumnProvider;
import dr.evomodel.continuous.hmc.TreePrecisionTraitProductProvider;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.KroneckerOperation;
import dr.math.matrixAlgebra.WrappedVector;
import java.util.HashMap;
import java.util.Map;

public class TreeKroneckerPrecisionColumnProvider
extends TreePrecisionColumnProvider {
    private final int precisionDim;
    private final MatrixParameterInterface diffusionPrecision;
    private final double[] buffer;
    private final Map<Integer, double[]> kroneckerCache = new HashMap<Integer, double[]>();
    private static final boolean DEBUG = false;

    public TreeKroneckerPrecisionColumnProvider(TreePrecisionTraitProductProvider treePrecisionTraitProductProvider, MultivariateDiffusionModel multivariateDiffusionModel) {
        super(treePrecisionTraitProductProvider);
        this.diffusionPrecision = multivariateDiffusionModel.getPrecisionParameter();
        this.precisionDim = this.diffusionPrecision.getColumnDimension();
        this.addVariable(this.diffusionPrecision);
        this.buffer = new double[this.precisionDim];
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = this.kroneckerCache.get(n);
        if (dArray == null) {
            int n2 = n / this.precisionDim;
            int n3 = n % this.precisionDim;
            double[] dArray2 = super.getColumn(n2);
            double[] dArray3 = this.getPrecisionColumn(n3);
            dArray = KroneckerOperation.product(dArray2, 1, dArray2.length, dArray3, 1, dArray3.length);
            this.kroneckerCache.put(n, dArray);
        }
        return dArray;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.diffusionPrecision) {
            this.kroneckerCache.clear();
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.kroneckerCache.clear();
        }
        super.handleModelChangedEvent(model, object, n);
    }

    private double[] getPrecisionColumn(int n) {
        double[] dArray = this.buffer;
        for (int i = 0; i < this.precisionDim; ++i) {
            dArray[i] = this.diffusionPrecision.getParameterValue(i, n);
        }
        return dArray;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        double[] dArray = this.getColumn(0);
        stringBuilder.append(new WrappedVector.Raw(dArray)).append("\n");
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(new WrappedVector.Raw(this.getColumn(i))).append("\n");
        }
        return stringBuilder.toString();
    }
}

