/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.siteratemodel;

import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;

public class GammaSiteRateModel
extends AbstractModel
implements SiteRateModel,
Citable {
    private Statistic muStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "mu";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public String getDimensionName(int n) {
            return this.getId();
        }

        @Override
        public double getStatisticValue(int n) {
            return GammaSiteRateModel.this.getMu();
        }
    };
    private Parameter nuParameter;
    private double muWeight;
    private Parameter shapeParameter;
    private Parameter invarParameter;
    private boolean ratesKnown;
    private int categoryCount;
    private double[] categoryRates;
    private double[] categoryProportions;
    public static final Citation CITATION_YANG94 = new Citation(new Author[]{new Author("Z", "Yang")}, "Maximum likelihood phylogenetic estimation from DNA sequences with variable rates over sites: approximate methods", 1994, "J. Mol. Evol.", 39, 306, 314, Citation.Status.PUBLISHED);
    private SubstitutionModel substitutionModel;

    public GammaSiteRateModel(String string) {
        this(string, null, 1.0, null, 0, null);
    }

    public GammaSiteRateModel(String string, double d, int n) {
        this(string, null, 1.0, new Parameter.Default(d), n, null);
    }

    public GammaSiteRateModel(String string, double d, int n, double d2) {
        this(string, null, 1.0, new Parameter.Default(d), n, new Parameter.Default(d2));
    }

    public GammaSiteRateModel(String string, Parameter parameter) {
        this(string, parameter, 1.0, null, -1, null);
    }

    public GammaSiteRateModel(String string, Parameter parameter, double d, Parameter parameter2, int n, Parameter parameter3) {
        super(string);
        this.nuParameter = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.muWeight = d;
        this.addStatistic(this.muStatistic);
        this.shapeParameter = parameter2;
        if (parameter2 != null) {
            this.categoryCount = n;
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        } else {
            this.categoryCount = 1;
        }
        this.invarParameter = parameter3;
        if (parameter3 != null) {
            ++this.categoryCount;
            this.addVariable(parameter3);
            parameter3.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
        this.categoryRates = new double[this.categoryCount];
        this.categoryProportions = new double[this.categoryCount];
        this.ratesKnown = false;
    }

    public void setMu(double d) {
        this.nuParameter.setParameterValue(0, d / this.muWeight);
    }

    public final double getMu() {
        return this.nuParameter.getParameterValue(0) * this.muWeight;
    }

    public void setAlpha(double d) {
        this.shapeParameter.setParameterValue(0, d);
        this.ratesKnown = false;
    }

    public final double getAlpha() {
        return this.shapeParameter.getParameterValue(0);
    }

    public void setRelativeRateParameter(Parameter parameter) {
        this.nuParameter = parameter;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        int n;
        GammaSiteRateModel gammaSiteRateModel = this;
        synchronized (gammaSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        int n2 = n = this.invarParameter != null ? 1 : 0;
        while (n < this.categoryRates.length) {
            if (this.categoryRates[n] == 0.0) {
                return null;
            }
            ++n;
        }
        return this.categoryRates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions() {
        GammaSiteRateModel gammaSiteRateModel = this;
        synchronized (gammaSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        GammaSiteRateModel gammaSiteRateModel = this;
        synchronized (gammaSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryRates[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n) {
        GammaSiteRateModel gammaSiteRateModel = this;
        synchronized (gammaSiteRateModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        return this.categoryProportions[n];
    }

    private void calculateCategoryRates() {
        int n;
        double d;
        int n2 = 0;
        if (this.invarParameter != null) {
            this.categoryRates[0] = 0.0;
            this.categoryProportions[0] = this.invarParameter.getParameterValue(0);
            n2 = 1;
        }
        if (this.shapeParameter != null) {
            d = this.shapeParameter.getParameterValue(0);
            n = this.categoryCount - n2;
            GammaSiteRateModel.setEqualRates(this.categoryRates, this.categoryProportions, d, n, n2);
        } else if (n2 > 0) {
            this.categoryRates[n2] = 2.0;
            this.categoryProportions[n2] = 1.0 - this.categoryProportions[0];
        } else {
            this.categoryRates[0] = 1.0;
            this.categoryProportions[0] = 1.0;
        }
        if (this.nuParameter != null) {
            d = this.getMu();
            n = 0;
            while (n < this.categoryCount) {
                int n3 = n++;
                this.categoryRates[n3] = this.categoryRates[n3] * d;
            }
        }
        this.ratesKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.shapeParameter) {
            this.ratesKnown = false;
        } else if (variable == this.invarParameter) {
            this.ratesKnown = false;
        } else if (variable == this.nuParameter) {
            this.ratesKnown = false;
        } else {
            throw new RuntimeException("Unknown variable in GammaSiteRateModelParser.handleVariableChangedEvent");
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    public void setSubstitutionModel(SubstitutionModel substitutionModel) {
        this.substitutionModel = substitutionModel;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Discrete gamma-distributed rate heterogeneity model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        if (this.shapeParameter != null) {
            arrayList.add(CITATION_YANG94);
        }
        return arrayList;
    }

    public static void setEqualRates(double[] dArray, double[] dArray2, double d, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            dArray[i + n2] = GammaDistribution.quantile((2.0 * (double)i + 1.0) / (2.0 * (double)n), d, 1.0 / d);
            dArray2[i + n2] = 1.0;
        }
        GammaSiteRateModel.normalize(dArray, dArray2);
    }

    public static void normalize(double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
            d2 += dArray2[n];
        }
        d /= (double)dArray.length;
        n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] / d;
            int n3 = n++;
            dArray2[n3] = dArray2[n3] / d2;
        }
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        GammaSiteRateModel.setEqualRates(dArray, dArray2, 1.0, 6, 0);
        System.out.println();
        System.out.println("Equal, alpha = 1.0");
        System.out.println("cat\trate\tproportion");
        for (int i = 0; i < 6; ++i) {
            System.out.println(i + "\t" + dArray[i] + "\t" + dArray2[i]);
        }
    }
}

