/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class ComplexSubstitutionModelAtStationarity
extends ComplexSubstitutionModel {
    private double[] stationaryDistribution;
    private double[] storedStationaryDistribution;
    private boolean stationaryDistributionKnown;
    private boolean storedStationaryDistributionKnown;

    public ComplexSubstitutionModelAtStationarity(String string, DataType dataType, Parameter parameter) {
        super(string, dataType, null, parameter);
        this.stationaryDistribution = new double[this.stateCount];
        this.storedStationaryDistribution = new double[this.stateCount];
        this.stationaryDistributionKnown = false;
        this.storedStationaryDistributionKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.stationaryDistributionKnown = false;
        super.handleVariableChangedEvent(variable, n, changeType);
    }

    @Override
    protected double[] getPi() {
        return this.getStationaryDistribution();
    }

    double[] getStationaryDistribution() {
        if (!this.stationaryDistributionKnown) {
            this.computeStationaryDistribution(this.stationaryDistribution);
            this.stationaryDistributionKnown = true;
        }
        return this.stationaryDistribution;
    }

    @Override
    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            for (n = n2 + 1; n < this.stateCount; ++n) {
                int n4 = n3++;
                d = dArray[n4];
                if (d < 0.0) {
                    d = 0.0;
                }
                dArray3[n2][n] = d;
            }
        }
        for (n = 0; n < this.stateCount; ++n) {
            for (n2 = n + 1; n2 < this.stateCount; ++n2) {
                int n5 = n3++;
                d = dArray[n5];
                if (d < 0.0) {
                    d = 0.0;
                }
                dArray3[n2][n] = d;
            }
        }
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.stationaryDistribution, 0, this.storedStationaryDistribution, 0, this.stateCount);
        this.storedStationaryDistributionKnown = this.stationaryDistributionKnown;
        super.storeState();
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.stationaryDistribution;
        this.stationaryDistribution = this.storedStationaryDistribution;
        this.storedStationaryDistribution = dArray;
        this.stationaryDistributionKnown = this.storedStationaryDistributionKnown;
        super.restoreState();
    }
}

