/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.util.Units;
import dr.evomodel.transmission.TransmissionDemographicModel;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class HierarchicalTransmissionDemographicModel
extends TransmissionDemographicModel {
    public static String HIERARCHICAL_TRANSMISSION_MODEL = "hierarchicalTransmissionModel";
    public static String CONSTANT = TransmissionDemographicModel.CONSTANT;
    public static String EXPONENTIAL = TransmissionDemographicModel.EXPONENTIAL;
    public static String LOGISTIC = TransmissionDemographicModel.LOGISTIC;
    public static String POPULATION_SIZE = TransmissionDemographicModel.POPULATION_SIZE;
    public static String ANCESTRAL_PROPORTION = TransmissionDemographicModel.ANCESTRAL_PROPORTION;
    public static String GROWTH_RATE = TransmissionDemographicModel.GROWTH_RATE;
    public static String DOUBLING_TIME = TransmissionDemographicModel.DOUBLING_TIME;
    public static final String HOST_COUNT = "hostCount";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.UNITS_RULE, AttributeRule.newIntegerRule("hostCount", false), new XORRule(new ElementRule(CONSTANT, new XMLSyntaxRule[]{new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the carrying capacity (maximum population size). If the shape is very large then the current day population size will be very close to the carrying capacity.")}), new XORRule(new ElementRule(EXPONENTIAL, new XMLSyntaxRule[]{new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(ANCESTRAL_PROPORTION, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the populaation size at transmission.")}), new ElementRule(LOGISTIC, new XMLSyntaxRule[]{new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the carrying capacity (maximum population size). If the shape is very large then the current day population size will be very close to the carrying capacity."), new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(ANCESTRAL_PROPORTION, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the populaation size at transmission.")})))};

        @Override
        public String getParserName() {
            return HIERARCHICAL_TRANSMISSION_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
            int n = 0;
            Parameter parameter = null;
            Parameter parameter2 = null;
            Parameter parameter3 = null;
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(CONSTANT)) {
                object = xMLObject.getChild(CONSTANT);
                parameter = (Parameter)((XMLObject)object).getElementFirstChild(POPULATION_SIZE);
                n = 0;
            } else if (xMLObject.hasChildNamed(EXPONENTIAL)) {
                object = xMLObject.getChild(EXPONENTIAL);
                parameter2 = (Parameter)((XMLObject)object).getElementFirstChild(ANCESTRAL_PROPORTION);
                if (((XMLObject)object).hasChildNamed(GROWTH_RATE)) {
                    parameter3 = (Parameter)((XMLObject)object).getElementFirstChild(GROWTH_RATE);
                } else {
                    parameter4 = (Parameter)((XMLObject)object).getElementFirstChild(DOUBLING_TIME);
                }
                n = 1;
            } else if (xMLObject.hasChildNamed(LOGISTIC)) {
                object = xMLObject.getChild(LOGISTIC);
                parameter = (Parameter)((XMLObject)object).getElementFirstChild(POPULATION_SIZE);
                parameter2 = (Parameter)((XMLObject)object).getElementFirstChild(ANCESTRAL_PROPORTION);
                if (((XMLObject)object).hasChildNamed(GROWTH_RATE)) {
                    parameter3 = (Parameter)((XMLObject)object).getElementFirstChild(GROWTH_RATE);
                } else {
                    parameter4 = (Parameter)((XMLObject)object).getElementFirstChild(DOUBLING_TIME);
                }
                n = 2;
            }
            object = new HierarchicalTransmissionDemographicModel(n, parameter, parameter2, parameter3, parameter4, type);
            ((HierarchicalTransmissionDemographicModel)object).resizeHierarchicalParameters(xMLObject.getAttribute(HierarchicalTransmissionDemographicModel.HOST_COUNT, 1));
            return object;
        }

        @Override
        public String getParserDescription() {
            return "A SiteModel that has a gamma distributed rates across sites";
        }

        @Override
        public Class getReturnType() {
            return HierarchicalTransmissionDemographicModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public HierarchicalTransmissionDemographicModel(int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this(HIERARCHICAL_TRANSMISSION_MODEL, n, parameter, parameter2, parameter3, parameter4, type);
    }

    public HierarchicalTransmissionDemographicModel(String string, int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        super(string, n, parameter, parameter2, parameter3, parameter4, type);
    }

    public void resizeHierarchicalParameters(int n) {
        if (this.N0Parameter != null) {
            this.N0Parameter.setDimension(n);
        }
        if (this.N1Parameter != null) {
            this.N1Parameter.setDimension(n);
        }
        if (this.growthRateParameter != null) {
            this.growthRateParameter.setDimension(n);
        }
        if (this.doublingTimeParameter != null) {
            this.doublingTimeParameter.setDimension(n);
        }
    }

    @Override
    protected int getIndexFromHost(int n) {
        return n - 1;
    }
}

