/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.GammaFunction;
import dr.math.distributions.MultivariateDistribution;

public abstract class AbstractLKJDistribution
implements MultivariateDistribution,
GradientProvider {
    protected double shape;
    protected int dim;
    double logNormalizationConstant;

    AbstractLKJDistribution(int n, double d) {
        assert (d > 0.0);
        this.shape = d;
        this.dim = n;
        this.logNormalizationConstant = this.computeLogNormalizationConstant();
    }

    AbstractLKJDistribution(int n) {
        this(n, 1.0);
    }

    private double computeLogNormalizationConstant() {
        double d = 0.0;
        if (this.shape == 1.0) {
            for (int i = 1; i <= (this.dim - 1) / 2; ++i) {
                d -= GammaFunction.lnGamma(2.0 * (double)i);
            }
            d = this.dim % 2 == 1 ? (d -= 0.25 * (double)(this.dim * this.dim - 1) * Math.log(Math.PI) - 0.25 * (double)(this.dim - 1) * (double)(this.dim - 1) * Math.log(2.0) - (double)(this.dim - 1) * GammaFunction.lnGamma(0.5 * (double)(this.dim + 1))) : (d -= 0.25 * (double)this.dim * (double)(this.dim - 2) * Math.log(Math.PI) + 0.25 * (double)(3 * this.dim * this.dim - 4 * this.dim) * Math.log(2.0) + (double)this.dim * GammaFunction.lnGamma(0.5 * (double)this.dim) - (double)(this.dim - 1) * GammaFunction.lnGamma(this.dim));
        } else {
            d = (double)(this.dim - 1) * GammaFunction.lnGamma(this.shape + 0.5 * (double)(this.dim - 1));
            for (int i = 1; i <= this.dim - 1; ++i) {
                d -= 0.5 * (double)i * Math.log(Math.PI) + GammaFunction.lnGamma(this.shape + 0.5 * (double)(this.dim - 1 - i));
            }
        }
        return d;
    }

    static int upperTriangularSize(int n) {
        return n * (n - 1) / 2;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }
}

