% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_y_ysr__pos_sum}
\alias{compute_mh_y_ysr__pos_sum}
\title{Compute "Youth Self Report [Youth] (Positive): Sum"}
\usage{
compute_mh_y_ysr__pos_sum(
  data,
  name = "mh_y_ysr__pos_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_ysr__pos_sum}
Youth Self Report [Youth] (Positive): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_ysr__pos_001}
\item \code{mh_y_ysr__pos_002}
\item \code{mh_y_ysr__pos_003}
\item \code{mh_y_ysr__pos_004}
\item \code{mh_y_ysr__pos_005}
\item \code{mh_y_ysr__pos_006}
\item \code{mh_y_ysr__pos_007}
\item \code{mh_y_ysr__pos_008}
\item \code{mh_y_ysr__pos_009}
\item \code{mh_y_ysr__pos_010}
\item \code{mh_y_ysr__pos_011}
\item \code{mh_y_ysr__pos_012}
\item \code{mh_y_ysr__pos_013}
\item \code{mh_y_ysr__pos_014}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 14 items missing
}
}
\examples{
\dontrun{
compute_mh_y_ysr__pos_sum(data) |>
  select(
    any_of(c("mh_y_ysr__pos_sum", vars_mh_y_ysr__pos))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_ysr__pos_nm]{compute_mh_y_ysr__pos_nm()}}
}
