% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_english_level.R
\name{calc_english_level}
\alias{calc_english_level}
\title{Calculate English Proficiency Level}
\usage{
calc_english_level(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer`.}
}
\value{
A data frame with two columns: `person_id` and `english_level`, where `english_level`
represents the participant's self-reported proficiency in English. Participants who did not respond
or provided a "PMI: Skip" will have an NA value.
}
\description{
This function creates an ordinal categorical variable that describes the level of proficiency
in English for participants who reported speaking a language other than English at home.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = c(40192529, 40192529, 40192529, 40192529, 40192529),
  answer = c("Very well", "Well", "Not well", "Not at all", "Skip")
)

# Compute English proficiency levels
english_level_scores <- calc_english_level(survey_df)
head(english_level_scores)

}
