% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_num_moves.R
\name{calc_num_moves}
\alias{calc_num_moves}
\title{Calculate Number of Moves in the Past Year}
\usage{
calc_num_moves(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer`.}
}
\value{
A data frame with two columns: `person_id` and `num_moves`, where `num_moves`
represents the number of moves in the past year for each participant. Participants without data or who skipped the question will have NA values.
}
\description{
This function creates a numeric variable representing the number of times a participant has moved in the past 12 months.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = rep(40192441, 5),
  answer = c("0", "1", "2", "3", "Skip")
)

# Compute number of moves in the past year
num_moves_scores <- calc_num_moves(survey_df)
head(num_moves_scores)

}
