% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat63}
\alias{simDat63}
\title{Simulate data for Chapter 6.3: Two groups with unequal variance}
\usage{
simDat63(n1 = 60, n2 = 40, mu1 = 105, mu2 = 77.5, sigma1 = 3, sigma2 = 2.5)
}
\arguments{
\item{n1}{The sample size of females}

\item{n2}{The sample size of males}

\item{mu1}{The population mean males}

\item{mu2}{The population mean females}

\item{sigma1}{The standard deviation for females}

\item{sigma2}{The standard deviation for males}
}
\value{
A list of simulated data and parameters.
  \item{n1}{Female sample size}
  \item{n2}{Male sample size}
  \item{mu1}{Female mean}
  \item{mu2}{Male mean}
  \item{beta}{Difference in wingspan mean between sexes}
  \item{sigma1}{Standard deviation for females}
  \item{sigma2}{Standard deviation for males}
  \item{x}{Indicator variable for sex, 1 = male}
  \item{y}{Simulated wingspan data}
}
\description{
Simulate wingspan measurements in female and male peregrines with unequal variance.
}
\examples{
str(dat <- simDat63())            # Implicit default arguments
str(dat <- simDat63(sigma1 = 5, sigma2 = 1)) # Very unequal variances

# Much larger sample sizes and larger difference in residual variation
str(dat <- simDat63(n1 = 10000, n2 = 10000, sigma1 = 5, sigma2 = 2))

# Revert to model with homoscedasticity
str(dat <- simDat63(n1 = 10000, n2 = 10000, sigma1 = 5, sigma2 = 5))

# Revert to "model-of-the-mean" (with larger sample size)
str(dat <- simDat63(n1 = 10000, n2 = 10000, mu1 = 105, mu2 = 105, sigma1 = 5, sigma2 = 5))

}
\author{
Marc Kéry
}
