% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat9}
\alias{simDat9}
\title{Simulate data for Chapter 9: ANCOVA or general linear model}
\usage{
simDat9(
  nPops = 3,
  nSample = 10,
  beta.vec = c(80, -30, -20, 6, -3, -4),
  sigma = 10
)
}
\arguments{
\item{nPops}{Number of populations}

\item{nSample}{Samples from each population}

\item{beta.vec}{Vector of regression parameter values}

\item{sigma}{Value for the residual standard deviation}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nSample}{Number of samples per population}
  \item{beta.vec}{Regression parameter values}
  \item{sigma}{Residual SD}
  \item{x}{Indicator for population number}
  \item{pop}{Population name (factor)}
  \item{lengthC}{Centered body length for each viper}
  \item{mass}{Simulated body mass for each viper}
}
\description{
Simulate mass ~ length regressions in 3 populations of asp vipers
}
\examples{
# Implicit default arguments (with interaction of length and pop)
str(dat <- simDat9())

# Revert to main-effects model with parallel lines
str(dat <- simDat9(beta.vec = c(80, -30, -20, 6, 0, 0)))

# Revert to main-effects model with parallel lines 
# (larger sample size to better show patterns)
str(dat <- simDat9(nSample = 100, beta.vec = c(80, -30, -20, 6, 0, 0)))

# Revert to simple linear regression: no effect of population 
# (larger sample size to better show patterns)
str(dat <- simDat9(nSample = 100, beta.vec = c(80, 0, 0, 6, 0, 0)))

# Revert to one-way ANOVA model: no effect of body length 
# (larger sample size to better show patterns)
str(dat <- simDat9(nSample = 100, beta.vec = c(80, -30, -20, 0, 0, 0)))

# Revert to "model-of-the-mean": no effects of either body length or population)
str(dat <- simDat9(nSample = 100, beta.vec = c(80, 0, 0, 0, 0, 0)))

}
\author{
Marc Kéry
}
