% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictBeeGUTS.R
\name{predict.beeSurvFit}
\alias{predict.beeSurvFit}
\title{Predict method for \code{beeSurvFit} objects}
\usage{
\method{predict}{beeSurvFit}(object, dataPredict, ...)
}
\arguments{
\item{object}{An object of class \code{beeSurvFit}}

\item{dataPredict}{Data to predict in the format as a dataframe containing the
following column:
\itemize{
\item \code{time}: A vector of time in days
\item \code{conc}: A vector of number of survivors of same length
\item \code{replicate} A vector replicate name
}}

\item{...}{Additional arguments to be parsed to the  \code{predict.survFit} method from \code{odeGUTS} (e.g.
\code{mcmc_size = 1000} is to be used to reduce the number of mcmc samples in order to speed up
the computation. \code{mcmc_size} is the number of selected iterations for one chain. Default
is 1000. If all MCMC is wanted, set argument to \code{NULL}.
\code{hb_value  = FALSE} the background mortality \code{hb} is set to a fixed value.
If \code{TRUE}, parameter \code{hb} taken from the posterior (If more than one dataset
is present, use the optional argument hb_dataset to specify which hb to use). The default is \code{FALSE}.
\code{hb_valueFORCED  = 0} hb_valueFORCED If \code{hb_value} is \code{FALSE}, it fix \code{hb}. The default is \code{0}}
}
\value{
A \code{beeSurvPred} object containing the results of the forwards prediction
}
\description{
This is the generic \code{predict} S3 method for the \code{beeSurvFit}
class. It predict the survival over time for the concentration profiles entered by the user.
No concentration reconstructions are performed here. Functions \code{\link[odeGUTS:predict]{odeGUTS::predict_ode()}}
from the \code{morse} package is used. This might be changed in a future update
}
\examples{
\donttest{
dataPredict <- data.frame(time = c(1:5, 1:15),
                          conc = c(rep(5, 5), rep(15, 15)),
                          replicate = c(rep("rep1", 5), rep("rep2", 15)))
data(fitBetacyfluthrin_Chronic)
prediction <- predict(fitBetacyfluthrin_Chronic, dataPredict)
}
}
