% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_gg_hydrographs.R
\name{ch_gg_hydrographs}
\alias{ch_gg_hydrographs}
\title{Hydrographs for WSC stations using \pkg{ggplot2}}
\usage{
ch_gg_hydrographs(
  WSC_stations,
  daily = TRUE,
  instantaneous = FALSE,
  facets = TRUE,
  common_dates = FALSE,
  start_date = NULL,
  end_date = NULL,
  hydat_path = NULL,
  inst_colour = "black",
  daily_colour = "black",
  ...
)
}
\arguments{
\item{WSC_stations}{Required. A vector of WSC station numbers.}

\item{daily}{Optional. If TRUE, mean daily streamflows are plotted as stair-steps.}

\item{instantaneous}{Optional. If TRUE, annual instantaneous peak flows are plotted as points.}

\item{facets}{Optional. If TRUE, the plot is faceted by station number.}

\item{common_dates}{Optional. If TRUE, a common date range is used for all 
time series.}

\item{start_date}{Optional. If specified (format = yyyy-mm-dd), only values on 
or following the date are plotted.}

\item{end_date}{Optional. If specified (format = yyyy-mm-dd), only values on or 
before the date are plotted.}

\item{hydat_path}{Optional. Path to the HYDAT database. Usually omitted unless 
you want to use a specific database file.}

\item{inst_colour}{Optional. Colour to be used for annual instantaneous peaks, 
if either facetted or only a single station is plotted. Default is "black".}

\item{daily_colour}{Optional. Colour to be used for daily flows, 
if either facetted or only a single station is plotted. Default is "black".}

\item{...}{Other parameters for the \pkg{ggplot} facets, if specified.}
}
\value{
Returns a \code{ggplot2} object of the hydrographs.
}
\description{
Acquires and plots values for WSC streamflows, using \pkg{ggplot2}. The existing 
functions \code{ch_qa_hydrograph} and
\code{ch_model_hydrograph} use basic \R plotting, require other functions to 
assemble the values, and only plot
values for a single station. This function is
able to plot hydrographs for more than one station, which may be useful, particularly 
when comparing responses for several streams in the same region.
}
\examples{
 \dontrun{
# Not run as this requires the installation of the HYDAT database

# plot a single station
stations <- c("05HH003")
p <- ch_gg_hydrographs(stations, daily = TRUE, instantaneous = TRUE)

# plot a group of stations in a region, as all appear to be responding to the same event
stations <-  c("05CC001", "05CC011", "05CD006", "05CD007", "05CE002", "05CE006", 
"05CE010", "05CE012", "05CE018", "05CE020", "05CG004", "05CG006")

p <- ch_gg_hydrographs(stations, daily = TRUE, instantaneous = FALSE, 
common_dates = FALSE, start_date = "2011-06-01", end_date = "2011-06-30", 
facets = TRUE, scales = "free_y", ncol= 3)
}
}
\seealso{
\code{\link{ch_qa_hydrograph}}  \code{\link{ch_model_hydrograph}}
}
\author{
Kevin Shook
}
