% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_generation.R
\name{generate_docker}
\alias{generate_docker}
\title{Generate Docker Configuration}
\usage{
generate_docker(
  output_dir,
  r_version = NULL,
  base_image = "rocker/r-ver",
  system_deps = NULL,
  project_name = "reproflow-project",
  include_rstudio = FALSE
)
}
\arguments{
\item{output_dir}{Character. Directory to save Docker files (required).}

\item{r_version}{Character. R version to use. Default is current R version.}

\item{base_image}{Character. Base Docker image. Default "rocker/r-ver"}

\item{system_deps}{Character vector. System dependencies to install}

\item{project_name}{Character. Name for the project}

\item{include_rstudio}{Logical. Include RStudio Server. Default FALSE.}
}
\value{
List of generated file paths
}
\description{
Generate a Dockerfile and docker-compose.yml for complete environment reproducibility
}
\examples{
\dontrun{
generate_docker(
  output_dir = tempdir(),
  project_name = "my_analysis",
  system_deps = c("libcurl4-openssl-dev", "libxml2-dev")
)
}
}
