% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFP.R
\name{calcFP}
\alias{calcFP}
\title{Calculate Frost Point}
\usage{
calcFP(Temp, RH)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}
}
\value{
Tf, Frost Point (°Celsius)
}
\description{
Function to calculate frost point (°C) from temperature (°C) and relative humidity (\%).
}
\details{
Formula coefficients from Arden Buck equation (1981, 1996) saturation vapor pressure over ice.

\itemize{
  \item a = 6.1115
  \item b = 23.036
  \item c = 279.82
  \item d = 333.7
}
}
\note{
This function is unstable and is under development.
}
\examples{
# calcFP is unstable and is under development
# Frost point at 20°C (Temp) and 50\% relative humidity (RH)
calcFP(20, 50)
calcFP(0, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(FrostPoint = calcFP(Temp, RH))


}
