% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_common_functions.R
\name{eval_Coxmos_model_per_variable.list}
\alias{eval_Coxmos_model_per_variable.list}
\title{eval_Coxmos_model_per_variable.list}
\usage{
eval_Coxmos_model_per_variable.list(
  lst_models,
  X_test,
  Y_test,
  pred.method = "cenROC",
  pred.attr = "mean",
  times = NULL,
  max_time_points = 15,
  PARALLEL = FALSE,
  n_cores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{lst_models}{List of Coxmos models.}

\item{X_test}{Numeric matrix or data.frame. Explanatory variables for test data (raw format).
Qualitative variables must be transform into binary variables.}

\item{Y_test}{Numeric matrix or data.frame. Response variables for test data. Object must have two
columns named as "time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for
censored and event observations.}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC").}

\item{pred.attr}{Character. Way to evaluate the metric selected. Must be one of the following:
"mean" or "median" (default: "mean").}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15).}

\item{PARALLEL}{Logical. Run the cross validation with multicore option. As many cores as your
total cores - 1 will be used. It could lead to higher RAM consumption (default: FALSE).}

\item{n_cores}{Numeric. Number of cores to use for parallel processing. This parameter is only
used if \code{PARALLEL} is \code{TRUE}. If \code{NULL}, it will use all available cores minus one. Otherwise,
it will use the minimum between the value specified and the total number of cores - 1. The fewer
cores used, the less RAM memory will be used.(default: NULL).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
A list of two objects:
\code{df}: A data.frame which the predictions for the specific model split into the full model (LP)
and each component individually. This data.frame is used to plot the information by the
function \code{plot_evaluation()}.
\code{lst_AUC}: A list of the full model prediction and its components where the user can check
the linear predictors used, the global AUC, the AUC per time point and the predicted time points
selected.
}
\description{
The \code{eval_Coxmos_model_per_variable.list} Run the function "eval_Coxmos_model_per_variable" for a list of models. More information
in "?eval_Coxmos_model_per_variable".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
splsicox.model <- splsicox(X_train, Y_train, n.comp = 2, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
splsdrcox.model <- splsdrcox_penalty(X_train, Y_train, n.comp = 2, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
lst_models = list("sPLSICOX" = splsicox.model, "sPLSDRCOX" = splsdrcox.model)
eval_Coxmos_model_per_variable.list(lst_models, X_test, Y_test, pred.method = "cenROC")
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
