% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_common_functions.R
\name{transformIllegalChars}
\alias{transformIllegalChars}
\title{transformIllegalChars}
\usage{
transformIllegalChars(cn, except = NULL, recover = FALSE)
}
\arguments{
\item{cn}{A character vector. Each element is a variable name to be sanitized or recovered.}

\item{except}{A character vector of illegal characters or replacement tokens that should be
excluded from the transformation or recovery process (default: NULL).}

\item{recover}{Logical. If TRUE, reverts tokens back to their original characters instead of
applying the transformation (default: FALSE).}
}
\value{
A character vector of transformed (or recovered) variable names, with illegal characters
replaced or restored as specified. If the final result is purely numeric, it is prefixed
with \code{"var_"} to ensure validity.
}
\description{
Transforms illegal or problematic characters in variable names into safe placeholder tokens to
ensure compatibility with programming or data handling environments. Optionally, this function
can also reverse these transformations if needed.
}
\details{
The function \code{transformIllegalChars} replaces characters that are typically considered illegal or
problematic in variable names—such as spaces, mathematical operators, or punctuation marks—with
descriptive placeholder tokens (e.g., \code{.space.}, \code{.comma.}). This is particularly useful for
variable names when exporting data, using variable names in formulas, or avoiding syntax errors.

The function supports two modes:
\itemize{
\item \strong{Standard mode (\code{recover = FALSE})}: Replaces illegal characters with placeholder tokens.
\item \strong{Recovery mode (\code{recover = TRUE})}: Replaces placeholder tokens back to their original illegal
characters.
}

The argument \code{except} allows specific characters or tokens to be exempted from transformation or
recovery. Additionally, after processing, the function checks whether all resulting values are
numeric and, if so, prepends \code{"var_"} to preserve name validity.

This function uses an auxiliary function \code{deleteIllegalChars()} to sanitize additional issues
before applying transformations.
}
\examples{
# Example 1: Transform illegal characters
original_names <- c("hsa-let-7a-2-3p", "hsa-let-7a-3p")
custom_formula_names <- transformIllegalChars(original_names)

# Example 2: Recover original characters from transformed names
recovered <- transformIllegalChars(custom_formula_names, recover = TRUE)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
