% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration_design_cst.R
\name{integration_design_cst}
\alias{integration_design_cst}
\title{Generic function to build integration points (for the SUR criterion)}
\usage{
integration_design_cst(
  integcontrol = NULL,
  lower,
  upper,
  model.fun = NULL,
  model.constraint = NULL,
  equality = FALSE,
  critcontrol = NULL,
  min.prob = 0.001
)
}
\arguments{
\item{integcontrol}{Optional list specifying the procedure to build the integration points and weights. 
Many options are possible.\cr 
A) If nothing is specified, 100*d points are chosen using the Sobol sequence. \cr
B) One can directly set the field \code{integration.points} (p * d matrix) for prespecified integration points. 
In this case these integration points and the corresponding vector \code{integration.weights} will be used 
for all the iterations of the algorithm. \cr
C) If the field \code{integration.points} is not set then the integration points are renewed at each iteration. 
In that case one can control the number of integration points \code{n.points} (default: 100*d) and a specific 
distribution \code{distrib}. Possible values for distrib are: "\code{sobol}", "\code{MC}" and "\code{SUR}"
 (default: "\code{sobol}"). \cr
C.1) The choice "\code{sobol}" corresponds to integration points chosen with the Sobol sequence in dimension d (uniform weight). \cr
C.2) The choice "\code{MC}" corresponds to points chosen randomly, uniformly on the domain. \cr
C.3) The choice "\code{SUR}" corresponds to importance sampling distributions (unequal weights). \cr
 When important sampling procedures are chosen, \code{n.points} points are chosen using importance sampling among a discrete 
 set of \code{n.candidates} points (default: \code{n.points}*10) which are distributed according to a distribution \code{init.distrib} 
 (default: "\code{sobol}"). Possible values for \code{init.distrib} are the space filling distributions "\code{sobol}" and "\code{MC}" 
 or an user defined distribution "\code{spec}". The "\code{sobol}" and "\code{MC}" choices correspond to quasi random and random points 
 in the domain. If the "\code{spec}" value is chosen the user must fill in manually the field \code{init.distrib.spec} to specify 
 himself a n.candidates * d matrix of points in dimension d.}

\item{lower}{Vector containing the lower bounds of the design space.}

\item{upper}{Vector containing the upper bounds of the design space.}

\item{model.fun}{object of class \code{\link[DiceKriging]{km}} corresponding to the objective functions,
or, if the objective function is fast-to-evaluate, a \code{\link[DiceOptim]{fastfun}} object,}

\item{model.constraint}{either one or a list of objects of class \code{\link[DiceKriging]{km}}, one for each constraint function,}

\item{equality}{either \code{FALSE} if all constraints are for inequalities, else a vector of boolean indicating which are equalities}

\item{critcontrol}{optional list of parameters (see \code{\link[DiceOptim]{crit_SUR_cst}}); here only the component \code{tolConstraints} is used.}

\item{min.prob}{This argument applies only when importance sampling distributions are chosen. 
For numerical reasons we give a minimum probability for a point to
belong to the importance sample. This avoids probabilities equal to zero and importance sampling
weights equal to infinity. In an importance sample of M points, the maximum weight becomes 
\code{1/min.prob * 1/M}.}
}
\value{
A list with components:
\itemize{
\item \code{integration.points} p x d matrix of p points used for the numerical calculation of integrals
\item \code{integration.weights} a vector of size p corresponding to the weight of each point. If all the points are equally 
weighted, integration.weights is set to NULL
}
}
\description{
Modification of the function  \code{\link[KrigInv]{integration_design}} from the package \code{KrigInv} to 
be usable for SUR-based optimization with constraints.
}
\references{
Chevalier C., Picheny V., Ginsbourger D. (2012), 
The KrigInv package: An efficient and user-friendly R implementation of Kriging-based inversion algorithms, 
\emph{Computational Statistics and Data Analysis}, 71, 1021-1034.

Chevalier C., Bect J., Ginsbourger D., Vazquez E., Picheny V., Richet Y. (2011), 
Fast parallel kriging-based stepwise uncertainty reduction with application to the identification of an excursion set,
\emph{Technometrics}, 56(4), 455-465.

V. Picheny (2014),
A stepwise uncertainty reduction approach to constrained global optimization,
\emph{Proceedings of the 17th International Conference on Artificial Intelligence and Statistics}, JMLR W&CP 33, 787-795.
}
\seealso{
\code{\link[DiceOptim]{crit_SUR_cst}} \code{KrigInv integration_design}
}
\author{
Victor Picheny 

Mickael Binois
}
