% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC.R
\name{PPC}
\alias{PPC}
\title{PPC: Principal Projection Components}
\usage{
PPC(data, m)
}
\arguments{
\item{data}{T x N data matrix.}

\item{m}{Number of components.}
}
\value{
List with Apro (loadings), Dpro (specific variances), Sigmahatpro.
}
\description{
Principal component projection method that extracts factor loadings and
specific variances through a projection matrix.
}
\examples{
\dontrun{
set.seed(123)
N <- 100; T <- 150; m.true <- 3
dat <- matrix(rnorm(T * N), T, N)
ppc.out <- EFM::PPC(dat, m = m.true)
print(round(ppc.out$Apro[1:5, 1:3], 3))
}
}
