% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical_errors.R
\name{elliptical_errors}
\alias{elliptical_errors}
\title{Calculate errors for elliptical distributions}
\usage{
elliptical_errors(data, distribution = "normal", df = NULL)
}
\arguments{
\item{data}{Matrix of data following an elliptical distribution.}

\item{distribution}{Type of elliptical distribution ("normal" or "t").}

\item{df}{Degrees of freedom for Elliptical-t Distribution (required if distribution is "t").}
}
\value{
A list containing error metrics for the specified elliptical distribution.
}
\description{
This function calculates errors for elliptical distributions, including Elliptical-Normal Distribution and Elliptical-t Distribution.
}
\details{
Calculate errors for elliptical distributions
}
\examples{
set.seed(123)
n <- 100; p <- 5
data_normal <- MASS::mvrnorm(n, rep(0, p), diag(p))
errors_normal <- elliptical_errors(data_normal, distribution = "normal")

data_t <- matrix(stats::rt(n * p, df = 5), nrow = n, ncol = p)
errors_t <- elliptical_errors(data_t, distribution = "t", df = 5)
print(errors_normal)
print(errors_t)
}
