% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamPlotSystem.R
\name{beamPlotSystem}
\alias{beamPlotSystem}
\title{beamPlotSystem}
\usage{
beamPlotSystem(beamP, beamT, PlotVal, a, b, c, d, e, f, g, h, i, j,
                  Oc, ac, bc, cc, dc, ec, fc, gc, hc, ic, jc, LWD)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{PlotVal}{Value to be plotted, either stress or strain, return from function beamLocalStress function.}

\item{a}{Threshold 1}

\item{b}{Threshold 2}

\item{c}{Threshold 3}

\item{d}{Threshold 4}

\item{e}{Threshold 5}

\item{f}{Threshold 6}

\item{g}{Threshold 7}

\item{h}{Threshold 8}

\item{i}{Threshold 9}

\item{j}{Threshold 10}

\item{Oc}{Color for all zero values}

\item{ac}{Color 1}

\item{bc}{Color 2}

\item{cc}{Color 3}

\item{dc}{Color 4}

\item{ec}{Color 5}

\item{fc}{Color 6}

\item{gc}{Color 7}

\item{hc}{Color 8}

\item{ic}{Color 9}

\item{jc}{Color 10}

\item{LWD}{Line (beam) width}
}
\value{
Plot of colored beam based on the plot value
}
\description{
Generates heat map for given stress or strain on the beam geometry. Threshold values for the color must be assigned.
}
\examples{
data(beamGeo)
data(beamStressResult)

PlotVal = beamStressResult

Oc = "slateblue"; ac = "steelblue2"; bc = "cyan2"; cc = "palegreen2";
dc = "darkolivegreen1"; ec = "lemonchiffon"; fc = "lightgoldenrod1";
gc = "gold"; hc= "lightsalmon"; ic= "tomato"; jc= "firebrick3"

a = 1e5;  b = 5e5;  c = 1e6;  d = 5e6;  e = 1e7;  f = 5e7;  g = 1e8;  h = 5e8; i = 1e9; j =5e9
beamPlotSystem(beamGeo$beamP, beamGeo$beamT, PlotVal, a, b, c, d, e, f, g, h, i, j, Oc,
ac, bc, cc, dc, ec, fc, gc, hc, ic, jc, LWD = 4)

}
