% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangulate0.2d.R
\name{triangulate0.2d}
\alias{triangulate0.2d}
\title{triangulate0.2d}
\usage{
triangulate0.2d(u0, edge)
}
\arguments{
\item{u0}{Matrix (2 x n) of node coordinates within the geometry.}

\item{edge}{Matrix (2 x n) of coordinate points on the perimeter of the geometry.}
}
\value{
Produces data for generated mesh.
\item{Meshpts}{Includes both new mesh coordinate points and triangulation of points.}
\item{Centroids}{Centroid positions for each triangle element.}
}
\description{
Triangulation by Delaunayn algorithm. Automatically generates a triangular mesh for a geometry containing nodal points.
}
\examples{
data(cleanpoly)
data(polyshape)

u0 = cleanpoly$CleanedNodes
edge = polyshape$Line

triMesh = triangulate0.2d(u0, edge)

}
