
#'
#' SecondObservation
#' 
#' SecondObservation is the raw data of DNE variables obtained from the second 
#' observation of the Southeast Asian sample. It consists of MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001 and Proportion.DNEover0.6.
#' 
#' @export
#' 
SecondObservation<-{
  MeanDNE.Apex <- c(0.026543, 0.032757, 0.024416, 0.016831, 0.022998, 0.017351, 0.01933, 0.021216, 0.020047, 0.020118, 0.0233, 0.013875, 0.020372, 0.02546, 0.02594, 0.025458, 0.021181, 0.031153, 0.025825, 0.020668, 0.024319, 0.026397, 0.029608, 0.038135, 0.016575, 0.029223, 0.026744, 0.025649, 0.028208, 0.037153, 0.02449, 0.021606, 0.022986, 0.020023, 0.029057, 0.020358, 0.024507, 0.021841, 0.01984, 0.026774, 0.028448, 0.023889, 0.036932, 0.028735, 0.028441, 0.033536, 0.031521, 0.036138, 0.047305, 0.021651, 0.027513, 0.034572, 0.032765, 0.018765, 0.024881, 0.016644, 0.032545, 0.029841, 0.03113, 0.031238, 0.018428, 
                    0.022635, 0.045507, 0.042692, 0.030157, 0.040214, 0.03415, 0.037998, 0.043562, 0.021053, 0.032511, 0.030154, 0.012344, 0.040014, 0.039843, 0.045067, 0.034303, 0.03357, 0.030564, 0.028239, 0.050599, 0.047983, 0.030941, 0.038468, 0.043835, 0.031179, 0.034813, 0.039396, 0.027578, 0.043154, 0.048968, 0.023151, 0.035369, 0.027451, 0.038219, 0.019806, 0.034246, 0.040663, 0.045132, 0.028332, 0.038123, 0.023739, 0.036434, 0.04034, 0.043187, 0.037864, 0.02547, 0.041567, 0.042393, 0.047994, 0.028353, 0.051421, 0.021388, 0.04593, 0.029767, 0.053427, 0.040972, 0.046656, 0.042526, 0.031561, 0.047386, 0.051444, 0.047135, 0.051577, 0.067427, 0.038323, 0.023215, 0.051456, 0.035328, 0.067151, 0.064212, 0.053723, 0.044447, 0.052785, 0.060054, 0.051321, 0.059217, 0.045004, 0.048498, 0.041354)
  MedianDNE.Apex <- c(0.002388, 0.006388, 0.013215, 0.000545, 0.005249, 0.008465, 0.003459, 0.003361, 0.006173, 0.004912, 0.002243, 0.001322, 0.003914, 0.005425, 0.002484, 0.003869, 0.001604, 0.005765, 0.007921, 0.001956, 0.00495, 0.003842, 0.009938, 0.010655, 0.004935, 0.004593, 0.006334, 0.005053, 0.009311, 0.008985, 0.007071, 0.002108, 0.00393, 0.004025, 0.007017, 0.009861, 0.008986, 0.007996, 0.011423, 0.008799, 0.014403, 0.009746, 0.007805, 0.013226, 0.021436, 0.012692, 0.011988, 0.010513, 0.021479, 0.017526, 0.035131, 0.009488, 0.011452, 0.020197, 0.010666, 0.015372, 0.018123, 0.010427, 0.01133, 0.018905, 0.018702, 0.016205, 0.020135, 0.00851, 0.016799, 0.009657, 0.015426, 0.017929, 0.011354, 
                      0.012421, 0.014983, 0.016545, 0.009717, 0.010374, 0.01019, 0.01455, 0.008507, 0.018432, 0.007304, 0.012459, 0.017224, 0.017824, 0.014422, 0.017151, 0.014855, 0.015211, 0.02087, 0.008648, 0.011624, 0.025448, 0.010847, 0.011317, 0.01113, 0.017922, 0.012808, 0.009224, 0.013071, 0.011399, 0.014322, 0.008205, 0.01989, 0.009626, 0.015017, 0.015498, 0.005432, 0.01658, 0.012423, 0.019956, 0.02518, 0.014038, 0.013433, 0.013023, 0.025255, 0.010558, 0.022616, 0.020066, 0.016256, 0.01957, 0.012048, 0.013545, 0.021438, 0.016518, 0.011528, 0.020439, 0.017982, 0.014132, 0.018666, 0.011425, 0.016133, 0.01532, 0.019524, 0.018431, 0.015899, 0.024604, 0.013715, 0.016694, 0.019256, 0.020503, 0.015537, 0.021173)
  IQRDNE.Apex <- c(0.013134, 0.019157, 0.013543, 0.015131, 0.015, 0.009769, 0.017844, 0.010351, 0.014627, 0.015126, 0.016825, 0.016318, 0.014856, 0.015271, 0.013244, 0.022344, 0.014844, 0.018804, 0.01623, 0.015353, 0.027651, 0.014752, 0.013451, 0.016239, 0.015973, 0.01753, 0.023151, 0.023561, 0.021491, 0.027514, 0.025413, 0.02179, 0.014693, 0.024517, 0.013544, 0.014513, 0.022197, 0.019886, 0.027845, 0.027812, 0.02037, 0.020254, 0.026499, 0.023451, 0.017659, 0.0202, 0.025288, 0.023151, 0.026786, 0.020903, 0.024376, 0.026214, 0.021859, 0.020132, 0.025844, 0.024589, 0.024135, 0.024206, 0.022527, 0.031239, 0.016673, 0.020607, 0.041235, 0.016584, 0.037451, 0.032284, 0.035121, 0.035125, 0.018134, 0.036764, 0.033706,
                   0.027435, 0.020627, 0.018435, 0.041313, 0.027844, 0.018428, 0.022512, 0.022, 0.017676, 0.042884, 0.04133, 0.031196, 0.020136, 0.025718, 0.027559, 0.034353, 0.034263, 0.023235, 0.030124, 0.025326, 0.015989, 0.030044, 0.026789, 0.022135, 0.028828, 0.020351, 0.028421, 0.034449, 0.027842, 0.034499, 0.027401, 0.031058, 0.032132, 0.025931, 0.044865, 0.023545, 0.037165, 0.031125, 0.025579, 0.017746, 0.032151, 0.015413, 0.030045, 0.040957, 0.020235, 0.024801, 0.028816, 0.030484, 0.036841, 0.037561, 0.035928, 0.038625, 0.038864, 0.031997, 0.032823, 0.030416, 0.031512, 0.029839, 0.012135, 0.037844, 0.027721, 0.040542, 0.048413, 0.039813, 0.035513, 0.041358, 0.047514, 0.043874, 0.040351)
  TotalDNE.TotalPolygonFaces <- c(0.006357, 0.005788, 0.013267, 0.006994, 0.008394, 0.012948, 0.010064, 0.011919, 0.015342, 0.009265, 0.014799, 0.012731, 0.018027, 0.007865, 0.014717, 0.014351, 0.005262, 0.020529, 0.010324, 0.007813, 0.016957, 0.010653, 0.016021, 0.024989, 0.016789, 0.033135, 0.023794, 0.018749, 0.010235, 0.018014, 0.020135, 0.018751, 0.012838, 0.025509, 0.014015, 0.017654, 0.026651, 0.014315, 0.019857, 0.021868, 0.021388, 0.018137, 0.022318, 0.024345, 0.018764, 0.018943, 0.022354, 0.023545, 0.020492, 0.026179, 0.02109, 0.016357, 0.026035, 0.013496, 0.027451, 0.020887, 0.014229, 0.021382, 0.011043, 0.028601, 0.023588, 0.014135, 0.013577, 0.014127, 0.023096, 0.014694, 
                                  0.028431, 0.015435, 0.023135, 0.019448, 0.024321, 0.017651, 0.032118, 0.031359, 0.021596, 0.021551, 0.027513, 0.025425, 0.024139, 0.027494, 0.03529, 0.029513, 0.016785, 0.014354, 0.025397, 0.030513, 0.020864, 0.024055, 0.028745, 0.022325, 0.005842, 0.008546, 0.021532, 0.025933, 0.024574, 0.031947, 0.023832, 0.010458, 0.024938, 0.027762, 0.036845, 0.0264, 0.017651, 0.023453, 0.032333, 0.023544, 0.020065, 0.01904, 0.038786, 0.011435, 0.037842, 0.024348, 0.023897, 0.036871, 0.029479, 0.024847, 0.023684, 0.035541, 0.034568, 0.033292, 0.043616, 0.040354, 0.035938, 0.046843, 0.037488, 0.019769, 0.042613, 0.037357, 0.025847, 0.026928, 0.040088, 0.050355, 0.038378, 0.047202, 0.039403, 0.029726, 0.049132, 0.035915, 0.03439, 0.037552)
  MedianDNE.Whole <- c(0.00254, 0.004405, 0.005812, 0.0106, 0.003841, 0.007683, 0.005826, 0.005029, 0.002662, 0.004359, 0.007313, 0.003989, 0.005475, 0.006218, 0.006964, 0.002129, 0.003625, 0.008831, 0.008754, 0.006158, 0.005758, 0.009845, 0.011388, 0.005491, 0.005001, 0.003447, 0.004522, 0.00857, 0.00423, 0.007046, 0.005829, 0.003986, 0.002724, 0.008876, 0.006199, 0.004728, 0.005095, 0.002563, 0.002163, 0.006368, 0.010987, 0.013577, 0.003955, 0.008359, 0.009843, 0.006095, 0.004689, 0.013543, 0.004877, 0.0041, 0.007709, 0.009845, 0.010035, 0.007639, 0.007151, 0.002719, 0.005177, 0.006132, 0.003717, 0.013327, 
                       0.005519, 0.006877, 0.003925, 0.010526, 0.017454, 0.007228, 0.008841, 0.006484, 0.012104, 0.010966, 0.011483, 0.006541, 0.010669, 0.008435, 0.007682, 0.00867, 0.005794, 0.007571, 0.008744, 0.005313, 0.00887, 0.013125, 0.008585, 0.010195, 0.012349, 0.008123, 0.013805, 0.007148, 0.012465, 0.014745, 0.010416, 0.008466, 0.012454, 0.006655, 0.013221, 0.010035, 0.01392, 0.009545, 0.004725, 0.009834, 0.011786, 0.004999, 0.013542, 0.013543, 0.00471, 0.014402, 0.011414, 0.014463, 0.009793, 0.008894, 0.011692, 0.013335, 0.010269, 0.005156, 0.007351, 0.010568, 0.013543, 0.014149, 0.010501, 0.008754, 0.013709, 0.009844, 0.015654, 0.01276, 0.011999, 0.01369, 0.012024, 0.010036, 0.007706, 0.014786, 0.013477, 0.010134, 0.009433, 0.010354, 0.011553, 0.011887, 0.011711, 0.015133, 0.01086, 0.010408)
  IQRDNE.Whole <- c(0.00833, 0.012735, 0.005773, 0.004312, 0.010331, 0.011479, 0.005285, 0.006654, 0.006452, 0.010811, 0.010064, 0.013244, 0.011819, 0.010705, 0.010993, 0.020062, 0.008971, 0.020315, 0.020315, 0.018115, 0.009329, 0.006686, 0.014445, 0.005865, 0.007474, 0.008377, 0.009655, 0.009143, 0.00728, 0.004864, 0.010876, 0.01702, 0.01385, 0.017172, 0.01991, 0.019539, 0.016679, 0.024651, 0.018988, 0.014901, 0.014781, 0.016172, 0.02282, 0.0135, 0.021263, 0.010329, 0.01471, 0.014742, 0.030284, 0.008344, 0.013999, 0.009904, 0.017796, 0.014531, 0.016733, 0.015854, 0.012383, 0.011325, 0.01432, 0.023151, 0.024861, 0.015753, 0.028431, 0.014384, 0.014326, 0.009228, 0.01717, 0.019458, 0.01996, 0.007703, 0.022233, 0.013543, 0.025237, 0.020398, 0.016055, 0.025172, 0.026219, 0.025216, 0.019725, 0.030544, 0.02844, 
                    0.012297, 0.027541, 0.017987, 0.025844, 0.022814, 0.019863, 0.001735, 0.026018, 0.027412, 0.013451, 0.025538, 0.021324, 0.015257, 0.018431, 0.013451, 0.033784, 0.030354, 0.013127, 0.020354, 0.030187, 0.026254, 0.026407, 0.021463, 0.027894, 0.020676, 0.026237, 0.019845, 0.027411, 0.027564, 0.029685, 0.017635, 0.028634, 0.03212, 0.023608, 0.023519, 0.023868, 0.030269, 0.021435, 0.02838, 0.034547, 0.028765, 0.03255, 0.034513, 0.043154, 0.023566, 0.033642, 0.038685, 0.023447, 0.030036, 0.036087, 0.027124, 0.031579, 0.022408, 0.024744, 0.024898, 0.038213, 0.021678, 0.023622, 0.040898)
  MeanDNE.Convex <- c(0.012042, 0.017907, 0.013612, 0.013615, 0.013403, 0.012609, 0.016358, 0.013847, 0.017532, 0.011774, 0.016296, 0.013508, 0.013009, 0.017886, 0.015991, 0.011996, 0.015221, 0.021455, 0.01827, 0.016407, 0.015243, 0.015789, 0.020574, 0.017779, 0.017343, 0.018391, 0.020167, 0.011175, 0.016773, 0.014695, 0.020719, 0.015451, 0.016321, 0.020243, 0.019657, 0.019145, 0.019753, 0.017669, 0.020836, 0.014273, 0.018002, 0.019129, 0.014584, 0.016092, 0.024987, 0.019988, 0.017253, 0.015544, 0.022369, 0.023779, 0.023833, 0.010772, 0.020064, 0.018752, 0.016505, 0.018702, 0.01949, 0.014779, 0.022563, 0.018005, 0.019079, 0.020214, 0.01925, 0.016259, 0.02133, 0.015299, 0.017731, 0.019075, 
                      0.023547, 0.019355, 0.019285, 0.019924, 0.02026, 0.020598, 0.016899, 0.024124, 0.021803, 0.020623, 0.019962, 0.018421, 0.020798, 0.021927, 0.017637, 0.022591, 0.022953, 0.019266, 0.020189, 0.023208, 0.013574, 0.013578, 0.021984, 0.027575, 0.021998, 0.023544, 0.019791, 0.020583, 0.022362, 0.022807, 0.01816, 0.020852, 0.029845, 0.019802, 0.015895, 0.019739, 0.018514, 0.022287, 0.024145, 0.014544, 0.022161, 0.024447, 0.015765, 0.02469, 0.022126, 0.028877, 0.025575, 0.013579, 0.020568, 0.02496, 0.02192, 0.021273, 0.023745, 0.027985, 0.026759, 0.025272, 0.027275, 0.016988, 0.0339, 0.02542, 0.026578, 0.030868, 0.031199, 0.033466, 0.030325, 0.037652, 0.024276, 0.029968, 0.030107, 0.025789, 0.028829, 0.030573)
  MeanDNE.Concave <- c(0.009767, 0.014681, 0.010701, 0.010007, 0.010559, 0.010307, 0.010789, 0.010825, 0.01374, 0.01191, 0.01517, 0.010234, 0.009632, 0.017391, 0.011324, 0.021159, 0.014917, 0.017191, 0.014868, 0.013008, 0.019493, 0.012342, 0.0148, 0.013744, 0.018477, 0.019875, 0.020512, 0.014577, 0.012026, 0.017084, 0.02102, 0.014998, 0.016538, 0.014591, 0.010971, 0.02071, 0.01665, 0.018487, 0.015571, 0.014325, 0.015878, 0.03064, 0.015962, 0.020537, 0.023435, 0.01542, 0.016752, 0.023525, 0.025054, 0.028446, 0.01775, 0.024539, 0.025685, 0.020572, 0.01479,
                       0.022398, 0.022297, 0.020862, 0.022089, 0.028368, 0.020121, 0.015002, 0.017982, 0.013217, 0.015465, 0.014531, 0.023061, 0.017544, 0.019054, 0.021968, 0.016816, 0.020334, 0.025265, 0.021172, 0.015434, 0.024784, 0.025475, 0.022355, 0.02094, 0.020354, 0.02868, 0.031205, 0.022289, 0.021457, 0.025017, 0.01494, 0.030922, 0.030244, 0.024543, 0.027604, 0.025039, 0.031813, 0.016343, 0.022409, 0.031247, 0.023454, 0.015591, 0.02514, 0.021513, 0.031108, 0.039465, 0.032667, 0.034899, 0.031525, 0.03166, 0.030554, 0.032065, 0.019975, 0.028256, 0.020535, 0.031221, 0.015991, 0.030405, 0.037908, 0.0307, 0.029743, 0.033628, 0.025923, 0.032292, 0.031514, 0.035326, 0.032603, 0.031637, 0.029545, 0.030247, 0.031575, 0.03566, 0.032256, 0.023357, 0.039949, 0.035158, 0.029417, 0.028054, 0.042533, 0.029534, 0.028434, 0.031531, 0.034308, 0.033698, 0.035522)
  Proportion.DNEunder0.0001 <- c(0.007099, 0.006896, 0.00875, 0.008123, 0.006092, 0.009397, 0.007764, 0.005442, 0.006841, 0.006852, 0.006855, 0.007314, 0.006572, 0.010234, 0.008465, 0.006061, 0.008325, 0.004212, 0.004234, 0.010169, 0.010354, 0.009954, 0.007681, 0.008151, 0.005258, 0.010044, 0.007175, 0.004231, 0.004663, 0.005768, 0.007513, 0.007848, 0.006502, 0.005369, 0.007425, 0.0058, 0.009163, 0.008034, 0.004819, 0.007316, 0.006468, 0.00479, 0.010357, 0.006213, 0.007228, 0.009432, 0.008132, 0.004319, 0.004974, 0.00428, 0.005121, 0.005596, 0.004132, 0.004895, 0.00521, 0.009134, 0.005105, 0.006123, 0.006238, 0.006851, 0.004114, 0.004873, 0.005157, 0.008385, 0.006543, 0.004709, 0.006137, 0.006801, 
                                 0.005912, 0.005125, 0.003231, 0.006213, 0.006409, 0.005023, 0.004591, 0.005212, 0.006213, 0.005123, 0.003466, 0.003255, 0.005404, 0.005132, 0.004291, 0.004893, 0.002321, 0.005607, 0.004438, 0.003042, 0.002977, 0.003845, 0.00315, 0.005789, 0.002165, 0.003044, 0.005969, 0.004159, 0.002406, 0.003154, 0.003684, 0.006942, 0.002691, 0.003909, 0.002805, 0.003875, 0.006013, 0.005125, 0.002493, 0.00361, 0.001985, 0.004924, 0.002645, 0.00333, 0.003641, 0.004151, 0.003291, 0.002876, 0.004021, 0.003245, 0.00459, 0.004551, 0.003793, 0.005124, 0.004556, 0.003385, 0.002235, 0.004056, 0.002211, 0.00388, 0.003543, 0.00234, 0.002865, 0.003616, 0.003447, 0.002269, 0.003213, 0.004761, 0.00265, 0.004312, 0.002845, 0.002439)
  Proportion.DNEover0.6 <- c(0.000445, 0.000636, 0.000143, 0.001172, 0.000842, 0.000234, 0.000483, 0.000942, 0.000475, 0.000331, 0.001235, 0.00042, 0.000491, 0.001574, 0.000927, 0.001865, 0.000887, 0.001933, 0.002564, 0.001222, 0.000984, 0.000746, 0.000603, 0.000799, 0.000768, 0.001035, 0.000421, 0.001312, 0.000612, 0.00098, 0.000368, 0.000927, 0.001325, 0.000513, 0.00051, 0.000396, 0.000599, 0.000474, 0.001107, 0.000412, 0.00133, 0.001621, 0.0005, 0.002126, 0.001565, 0.001706, 0.001597, 0.001634, 0.001332, 0.001924, 0.002014, 0.001121, 0.002561, 0.000658, 0.002239, 0.001651, 0.001545, 0.000871, 0.000781, 0.002237, 0.001953, 0.000654, 0.001486, 0.002354, 0.001118, 0.002223, 0.001868, 0.000254, 0.002163, 0.001546, 0.001297, 0.001635, 0.002298, 0.001543, 0.001325, 0.001465, 0.001898, 0.001988, 
                             0.001705, 0.001869, 0.001085, 0.002132, 0.002325, 0.001252, 0.002437, 0.001316, 0.001195, 0.002433, 0.002063, 0.001354, 0.001912, 0.002334, 0.002018, 0.002124, 0.002211, 0.002258, 0.002655, 0.001979, 0.001023, 0.002334, 0.002985, 0.002157, 0.002068, 0.001023, 0.002309, 0.002355, 0.002785, 0.001601, 0.003532, 0.001368, 0.001222, 0.001898, 0.001953, 0.001753, 0.001988, 0.001663, 0.002985, 0.001209, 0.002945, 0.001123, 0.001346, 0.001764, 0.00221, 0.002004, 0.004276, 0.001843, 0.003943, 0.002751, 0.001766, 0.003483, 0.003214, 0.001123, 0.002616, 0.002865, 0.002992, 0.002255, 0.001746, 0.001087, 0.002987, 0.004027)
  SecondObservation <- data.frame(MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001, Proportion.DNEover0.6)
  SecondObservation
}

#' @examples 
#' SecondObservation