% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitialSubset.R
\name{InitialSubset}
\alias{InitialSubset}
\title{InitialSubset}
\usage{
InitialSubset(
  TE,
  seTE,
  treat1,
  treat2,
  studlab,
  crit1,
  studies,
  P,
  reference,
  t1.label,
  t2.label,
  n_cores,
  ...
)
}
\arguments{
\item{TE}{Estimate of treatment effect, i.e. difference between
first and second treatment (e.g. log odds ratio, mean difference,
or log hazard ratio).}

\item{seTE}{Standard error of treatment estimate.}

\item{treat1}{Label/Number for first treatment.}

\item{treat2}{Label/Number for second treatment.}

\item{studlab}{Study labels (important when multi arm studies are
included).}

\item{crit1}{A character string indicating the criterion to be used
for selecting the initial subset, this criterion could be the
minimum of median absolute residuals ("R") or the maximum of
median absolute likelihood contributions ("L"). Default value is
"R".}

\item{studies}{An optional vector specifying a subset of studies to
be used.  The default value is the number of studies.}

\item{P}{An optional vector specifying the number of samples for
the choice of the initial subset.}

\item{reference}{Reference treatment group.}

\item{t1.label}{numbers to treatment 1 IDs.}

\item{t2.label}{numbers to treatment 2 IDs.}

\item{n_cores}{the number of cores that the process is running
using the parallel.}
}
\value{
An initial clean subset of studies.
}
\description{
Choose an initial clean (i.e. likely outlier-free) subset of
studies.
}
\keyword{internal}
