% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{SAHemorrhage_df}
\alias{SAHemorrhage_df}
\title{Subarachnoid Hemorrhage Clinical and Laboratory Data}
\format{
A data frame with 113 observations and 7 variables:
\describe{
  \item{gos6}{Glasgow Outcome Scale at 6 months (ordered factor with 5 levels)}
  \item{outcome}{Clinical outcome classification (factor with 2 levels)}
  \item{gender}{Gender of the patient (factor with 2 levels)}
  \item{age}{Age of the patient (integer)}
  \item{wfns}{WFNS clinical grade (ordered factor with 5 levels)}
  \item{s100b}{S100B biomarker level (numeric)}
  \item{ndka}{Nucleoside diphosphate kinase A level (numeric)}
}
}
\source{
Data taken from the reportROC package version 3.6
}
\usage{
data(SAHemorrhage_df)
}
\description{
This dataset, SAHemorrhage_df, is a data frame containing clinical and laboratory variables from
113 patients diagnosed with aneurysmal subarachnoid hemorrhage. The dataset includes functional
outcomes, demographic information, clinical severity scores, and biomarker measurements. These data
provide valuable information for studying neurological prognosis, biomarker associations, and clinical
patterns in patients with subarachnoid hemorrhage.
}
\details{
The dataset name has been kept as SAHemorrhage_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
