% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{blood_brain_barrier_df}
\alias{blood_brain_barrier_df}
\title{Blood-Brain Barrier}
\format{
A data frame with 34 observations and 9 variables:
\describe{
  \item{Brain}{Integer: Brain tissue measurement (units?)}
  \item{Liver}{Integer: Liver tissue measurement (units?)}
  \item{Time}{Numeric: Experimental time measurement (hours)}
  \item{Treatment}{Factor with 2 levels: Experimental treatment groups}
  \item{Days}{Integer: Observation period (days)}
  \item{Sex}{Factor with 2 levels: Animal sex (Male/Female)}
  \item{Weight}{Integer: Subject weight (grams)}
  \item{Loss}{Numeric: Physiological loss measurement}
  \item{Tumor}{Integer: Tumor presence indicator (0/1)}
}
}
\source{
Data taken from the Sleuth3 package version 1.0-6. Original reference:
Ramsey, F.L. and Schafer, D.W. (2013) \emph{The Statistical Sleuth: A Course in Methods
of Data Analysis} (3rd ed), Cengage Learning.
}
\usage{
data(blood_brain_barrier_df)
}
\description{
This dataset, blood_brain_barrier_df, is a data frame containing experimental measurements
from a rat study investigating sugar-infusion methods for temporary blood-brain barrier
disruption. The barrier's protective function was assessed through multiple biological markers.
}
\details{
The dataset name has been kept as 'blood_brain_barrier_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
