% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onam.R
\name{onam}
\alias{onam}
\title{Fit orthogonal neural additive model}
\usage{
onam(
  formula,
  list_of_deep_models,
  data,
  model = NULL,
  prediction_function = NULL,
  model_data = NULL,
  categorical_features = NULL,
  target = "continuous",
  n_ensemble = 10,
  epochs = 500,
  callback = NULL,
  progresstext = FALSE,
  verbose = 0
)
}
\arguments{
\item{formula}{Formula for model fitting. Specify deep parts with the same
name as \code{list_of_deep_models}.}

\item{list_of_deep_models}{List of named models used in \code{model_formula}.}

\item{data}{Data to be fitted}

\item{model}{Prediction model that is to be explained. Output of the model as
returned from \code{prediction_function(model)} will be used as model output. If
\code{NULL}(default), the outcome has to be present in \code{data}.}

\item{prediction_function}{Prediction function to be used to generate the
outcome. Only used if \code{model} is specified. If \code{NULL}(default), S3-method
based on the \code{model}argument is used.}

\item{model_data}{Data used for generating predictions of \code{model}. Necessary
for some models that require specific data formats, i.e. xgboost.
If \code{NULL}(default), \code{data} is used. Only used if \code{model} is specified.}

\item{categorical_features}{Vector of feature names of categorical features.}

\item{target}{Target of prediction task. Can be either "continuous" or
"binary". For "continuous"(default), an additive model for the prediction of
a continuous outcome is fitted. For "binary", a binary classification with
sigmoid activation in the last layer is fitted.}

\item{n_ensemble}{Number of orthogonal neural additive model ensembles}

\item{epochs}{Number of epochs to train the model. See
\code{\link[keras3]{fit}} for details.}

\item{callback}{Callback to be called during training. See
\code{\link[keras3]{fit}} for details.}

\item{progresstext}{Show model fitting progress. If \code{TRUE}, shows current
number of ensemble being fitted}

\item{verbose}{Verbose argument for internal model fitting. used for
debugging. See \code{\link[keras3]{fit}} for
details.}
}
\value{
Returns a model object of class \code{onam}, containing all ensemble
members, ensemble weights, and main and interaction effect outputs.
}
\description{
Fits an interpretable neural additive model with post hoc orthogonalization
for a given network architecture and user-specified feature sets.
}
\examples{
\dontshow{if (reticulate::py_module_available(tensorflow)) withAutoprint(\{ # examplesIf}
# Basic example for a simple ONAM-model
# Create training data
n <- 1000
x1 <- runif(n, -2, 2)
x2 <- runif(n, -2, 2)
y <- sin(x1) + ifelse(x2 > 0, pweibull(x2, shape = 3),
  pweibull(-x2, shape = 0.5)) +
  x1 * x2
data_train <- cbind(x1, x2, y)
# Define model
model_formula <- y ~ mod1(x1) + mod1(x2) +
  mod1(x1, x2)
mod1 <- function(inputs) {
  outputs <- inputs \%>\%
    layer_dense(units = 16, activation = "relu") \%>\%
 layer_dense(units = 8, activation = "linear",
             use_bias = TRUE) \%>\%
 layer_dense(units = 1, activation = "linear",
             use_bias = TRUE)
 keras_model(inputs, outputs)
}
list_of_deep_models <- list(mod1 = mod1)
# Fit model
mod <- onam(model_formula, list_of_deep_models,
            data_train, n_ensemble = 1, epochs = 10)
summary(mod)
\dontshow{\}) # examplesIf}
}
