% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseClinicalRecords.R
\name{summariseClinicalRecords}
\alias{summariseClinicalRecords}
\title{Summarise an omop table from a cdm object}
\usage{
summariseClinicalRecords(
  cdm,
  omopTableName,
  recordsPerPerson = c("mean", "sd", "median", "q25", "q75", "min", "max"),
  conceptSummary = TRUE,
  missingData = TRUE,
  quality = TRUE,
  sex = FALSE,
  ageGroup = NULL,
  dateRange = NULL,
  inObservation = lifecycle::deprecated(),
  standardConcept = lifecycle::deprecated(),
  sourceVocabulary = lifecycle::deprecated(),
  domainId = lifecycle::deprecated(),
  typeConcept = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object. Run \code{clinicalTables()} to check the
available options.}

\item{recordsPerPerson}{Generates summary statistics for the number of
records per person. Set to NULL if no summary statistics are required.}

\item{conceptSummary}{Logical. If \code{TRUE}, includes summaries of concept-level
information, including:
\itemize{
\item Domain ID of standard concepts.
\item Type concept ID.
\item Standard vs non-standard concepts.
\item Source vocabulary usage.
}}

\item{missingData}{Logical. If \code{TRUE}, includes a summary of missing data for
relevant fields.}

\item{quality}{Logical. If \code{TRUE}, performs basic data quality checks,
including:
\itemize{
\item Percentage of records within the observation period.
\item Number of records with end date before start date.
\item Number of records with start date before the person's birth date.
}}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}

\item{inObservation}{Deprecated. Use \code{quality = TRUE} instead.}

\item{standardConcept}{Deprecated. Use \code{conceptSummary = TRUE} instead.}

\item{sourceVocabulary}{Deprecated. Use \code{conceptSummary = TRUE} instead.}

\item{domainId}{Deprecated. Use \code{conceptSummary = TRUE} instead.}

\item{typeConcept}{Deprecated. Use \code{conceptSummary = TRUE} instead.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
You will obtain information related to the number of records, number of
subjects, whether the records are in observation, number of present domains,
number of present concepts, missing data and inconsistencies in start date
and end date.
}
\examples{
\donttest{
library(OmopSketch)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseClinicalRecords(
  cdm = cdm,
  omopTableName = "condition_occurrence",
  recordsPerPerson = c("mean", "sd"),
  quality = TRUE,
  conceptSummary = TRUE,
  missingData = TRUE
)

tableClinicalRecords(result = result)

cdmDisconnect(cdm = cdm)
}

}
