% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{penguins_raw_df}
\alias{penguins_raw_df}
\title{Penguin Size, Clutch, and Blood Isotope Data for Foraging Adults near Palmer Station, Antarctica}
\format{
A data frame with 344 observations and 17 variables:
\describe{
  \item{studyName}{Name of the study or project.}
  \item{Sample Number}{Unique numeric sample identifier.}
  \item{Species}{Species name (character).}
  \item{Region}{Region of the Palmer Archipelago (character).}
  \item{Island}{Island of observation (character).}
  \item{Stage}{Stage of breeding or observation period (character).}
  \item{Individual ID}{Unique penguin identifier (character).}
  \item{Clutch Completion}{Clutch completion status (character).}
  \item{Date Egg}{Date the egg was recorded (Date).}
  \item{Culmen Length (mm)}{Bill length in millimeters (numeric).}
  \item{Culmen Depth (mm)}{Bill depth in millimeters (numeric).}
  \item{Flipper Length (mm)}{Flipper length in millimeters (numeric).}
  \item{Body Mass (g)}{Body mass in grams (numeric).}
  \item{Sex}{Sex of the penguin (character).}
  \item{Delta 15 N (o/oo)}{Nitrogen isotope ratio \eqn{\delta^{15}N} (per mil).}
  \item{Delta 13 C (o/oo)}{Carbon isotope ratio \eqn{\delta^{13}C} (per mil).}
  \item{Comments}{Additional notes and remarks (character).}
}
}
\source{
Data taken from the palmerpenguins package version 0.1.1
}
\usage{
data(penguins_raw_df)
}
\description{
This dataset, penguins_raw_df, is a data frame containing comprehensive biological data
for adult penguins observed near Palmer Station, Antarctica. It includes size measurements,
clutch completion status, blood isotope values, and additional observational metadata.
The dataset covers three penguin species from three islands in the Palmer Archipelago.
}
\details{
The columns of penguins_raw_df extend those of the penguins_df dataset, adding details
such as study name, individual ID, clutch information, isotope composition
(\eqn{\delta^{15}N} and \eqn{\delta^{13}C}),
and additional observational notes. Some variables include missing values.

The dataset name has been kept as 'penguins_raw_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PenguinR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
