% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_plot.R
\name{pp_plot}
\alias{pp_plot}
\title{Plot a policy portfolio}
\usage{
pp_plot(D, id = NULL, spacing = FALSE, subtitle = TRUE, caption = NULL)
}
\arguments{
\item{D}{Data frame in a tidy format with the following columns: "Country", "Sector", "Year", "Instrument", "Target" and "covered". "covered" is a binary identificator of whether the portfolio space is covered by policy intervention (1) or not (0). The remaining columns identify the case. Notice that "Year" is a numeric value, while the remaining 4 case identifiers are factors.}

\item{id}{A list with up to two elements, namely "Country", and "Year" indicating the specific identification characteristics of the portfolio(s) that must be processed.}

\item{spacing}{Logical value. When TRUE, some space is added between tiles to help distinguish adjacent spaces. Defaults to FALSE.}

\item{subtitle}{Logical value. When TRUE (the default), a subtitle with the measures of the portfolio is included.}

\item{caption}{A character vector to overimpose the Source of the data. For the CONSENSUS dataset, please use "citation(PolicyPortfolios)" to properly cite its source.}
}
\value{
A tidy dataset containing the portfolio identificators (Country, Sector and Year) plus the Measure identificators (Measure and Measure.label) and the value of the portfolio characteristic.
}
\description{
Plot a policy portfolio.
}
\examples{
data(P.education)
pp_plot(P.education, id = list(Country = "Borduria", Year = 2025))
}
