% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_sectional.R
\name{rank_within_sector}
\alias{rank_within_sector}
\title{Rank Indicators Within Each Sector}
\usage{
rank_within_sector(
  indicator_df,
  sector_mapping,
  method = c("percentile", "rank", "z-score"),
  min_sector_size = 3
)
}
\arguments{
\item{indicator_df}{Data frame with Date column and indicator values}

\item{sector_mapping}{Data frame with \code{Symbol} and \code{Sector} columns.}

\item{method}{"percentile" (0-100), "rank" (1-N), or "z-score"}

\item{min_sector_size}{Minimum stocks per sector (default: 3)}
}
\value{
Data frame with within-sector ranks/scores
}
\description{
Ranks stocks within their sector for sector-neutral strategies. Enables
selecting best stocks from each sector regardless of sector performance.
Optimized using matrix operations within groups.
}
\examples{
data("sample_prices_weekly")
data("sample_sp500_sectors")
momentum <- calc_momentum(sample_prices_weekly, 12)
sector_ranks <- rank_within_sector(momentum, sample_sp500_sectors)
}
