% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcTrans.R
\name{mcTrans}
\alias{mcTrans}
\title{Access Markov Chain Transition Matrix in the MACRAME Algorithm}
\usage{
mcTrans(object)
}
\arguments{
\item{object}{An object of class \code{profileLadder}.}
}
\value{
The matrix of the estimated Markov chain transition probabilities
}
\description{
Retrieves the Markov chain components from a \code{profileLadder} object returned
from the function \code{mcReserve()} -- in particular, the function returns
the matrix of the estimated transition probabilities used by the underlying
Markov Chain to provide the reserve prediction.
}
\examples{
## MACRAME reserve prediction with the DEFAULT Markov chain setup 
output <- mcReserve(CameronMutual)

## Extracting the corresponding break points
mcTrans(output)

}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=mcBreaks]{mcBreaks()}}, \code{\link[=mcStates]{mcStates()}}
}
