% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_properties.R, R/00_globals.R
\name{get_properties}
\alias{get_properties}
\alias{property_map}
\title{Retrieve Compound Properties from PubChem}
\usage{
get_properties(
  properties = NULL,
  identifier,
  namespace = "cid",
  searchtype = NULL,
  options = NULL,
  propertyMatch = list(.ignore.case = FALSE, type = "contain")
)

property_map(
  x,
  type = c("match", "contain", "start", "end", "all"),
  .ignore.case = TRUE,
  ...
)
}
\arguments{
\item{properties}{A character vector specifying the properties to retrieve.
If \code{NULL} (default), all available properties are retrieved.
Properties can be specified by exact names, partial matches, or patterns, controlled by the \code{propertyMatch} argument.
For a full list of properties, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Compound-Property-Tables}{Property Table}.}

\item{identifier}{A vector of compound identifiers, either numeric or character.
The type of identifier depends on the \code{namespace} parameter.
**Note**: \code{identifier} must be provided; it cannot be \code{NULL}.}

\item{namespace}{A character string specifying the namespace of the identifier.

                 Possible values include:

                 - \code{cid}: PubChem Compound Identifier (default)

                 - \code{name}: Chemical name

                 - \code{smiles}: SMILES string

                 - \code{inchi}: InChI string

                 - \code{inchikey}: InChIKey

                 - \code{formula}: Molecular formula

                 - Other namespaces as specified in the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Input}{API documentation}.}

\item{searchtype}{An optional character string specifying the search type.

                  Possible values include:

                  - \code{similarity}

                  - \code{substructure}

                  - \code{superstructure}

                  - \code{identity}

                  - Other search types as specified in the API documentation.

                  If \code{NULL} (default), no search type is specified.

                  For more details, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Input}{API documentation}.}

\item{options}{A list of additional options for the request.

               Available options depend on the specific request and the API.

               Examples include:

               - For similarity searches: \code{list(Threshold = 95)}

               - For substructure searches: \code{list(MaxRecords = 100)}

               If \code{NULL} (default), no additional options are included.

               For more details, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Structure-Search-Operations}{Structure Search Operations} section of the PUG REST API.}

\item{propertyMatch}{A list of arguments to control how properties are matched.

                     The list can include:

                     - \code{type}: The type of match. Possible values are \code{exact}, \code{contain}, \code{match}. Default is \code{contain}.

                     - \code{.ignore.case}: Logical value indicating if the match should ignore case. Default is \code{FALSE}.

                     - \code{x}: The properties to match (set internally; do not set manually).

                     Default is \code{list(.ignore.case = FALSE, type = "contain")}.}

\item{x}{A character vector of compound properties. The \link{property_map} function will search for each property provided here within the available properties. The search can be customized using the \code{type} argument. This argument is ignored if \code{type = "all"}.}

\item{type}{Defines how to search within the available properties. The default is "match". See Notes for details.}

\item{.ignore.case}{A logical value. If TRUE, the pattern match ignores case letters. This argument is ignored if \code{type = "all"}. The default is TRUE.}

\item{...}{Other arguments. Currently, these have no effect on the function's return.}
}
\value{
An object of class "PubChemInstanceList" containing all the properties of the requested compounds.
}
\description{
This function sends a request to PubChem to retrieve compound properties based on the specified parameters.
}
\details{
For more detailed information, please refer to the
\href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest}{PubChem PUG REST API documentation}.
}
\note{
\subsection{Property Map:}{
  \code{property_map()} is not used to request properties directly from the PubChem database. This function is intended to list the available compound properties that can be requested from PubChem. It has flexible options to search properties from the available property list of the PubChem database. The output of \link{property_map} is used as the \code{property} input in the \link{get_properties} function. This function may be practically used to request specific properties across a range of compounds. See examples for usage.
}
}
\examples{
\donttest{
# Isomeric SMILES of the compounds
props <- get_properties(
  properties = c("MolecularWeight", "MolecularFormula", "InChI"),
  identifier = c("aspirin", "ibuprofen", "caffeine"),
  namespace = "name"
)

# Properties for a selected compound
instance(props, "aspirin")
retrieve(props, .which = "aspirin", .slot = NULL)
retrieve(instance(props, "aspirin"), .slot = NULL)

# Combine properties of all compounds into a single data frame (or list)
retrieve(props, .combine.all = TRUE)

# Return selected properties
retrieve(props, .combine.all = TRUE,
  .slot = c("MolecularWeight", "MolecularFormula"))

# Return properties for the compounds in a range of CIDs
props <- get_properties(
  properties = c("mass", "molecular"),
  identifier = 2244:2255,
  namespace = "cid",
  propertyMatch = list(
    type = "contain"
  )
)

retrieve(props, .combine.all = TRUE, .to.data.frame = TRUE)

# Return all available properties of the requested compounds
props <- get_properties(
  properties = NULL,
  identifier = 2244:2245,
  namespace = "cid",
  propertyMatch = list(
    type = "all"
  )
)

retrieve(props, .combine.all = TRUE)

}

#### EXAMPLES FOR property_map() ####
# List all available properties:
property_map(type = "all")

# Exact match:
property_map("InChI", type = "match")
property_map("InChi", type = "match",
  .ignore.case = TRUE) # Returns no match. Ignores '.ignore.case'

# Match at the start/end:
property_map("molecular", type = "start", .ignore.case = TRUE)
property_map("mass", type = "end", .ignore.case = TRUE)

# Partial match with multiple search patterns:
property_map(c("molecular", "mass", "inchi"),
  type = "contain", .ignore.case = TRUE)

}
