% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{n.rb}
\alias{n.rb}
\title{Risk-based sample size}
\usage{
n.rb(pstar, rr, ppr, spr, se, sep)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector, length equal to the number of risk strata)}

\item{ppr}{population proportions corresponding to rr values 
(vector of equal length to rr)}

\item{spr}{planned surveillance proportion for each risk group 
(vector equal length to rr, ppr)}

\item{se}{unit sensitivity (fixed or vector same length as rr, ppr, n)}

\item{sep}{required population sensitivity (scalar)}
}
\value{
list of 2 elements, a vector of sample sizes for each risk group
  a scalar of total sample size, a vector of EPI values and a vector of
  adjusted risks
}
\description{
Calculates sample size for risk-based sampling 
  for a single risk factor and using binomial method
}
\examples{
# examples for n.rb
n.rb(0.1, c(5, 3, 1), c(0.1, 0.10, 0.80), c(0.5, 0.3, 0.2), 0.9, 0.95)
n.rb(0.01, c(5, 1), c(0.1, 0.9), c(0.8, 0.2), c(0.9, 0.95), 0.95)
}
\keyword{methods}
