% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvp_calib_template.R
\name{rvn_rvp_calib_template}
\alias{rvn_rvp_calib_template}
\title{Rewrite rvp file with placeholder values}
\usage{
rvn_rvp_calib_template(
  rvp_file = NULL,
  rvp_outfile = NULL,
  ost_outfile = "ostIn.txt",
  params_calibration = NULL,
  overwrite = FALSE,
  RavenParamsFile = system.file("extdata", "RavenParameters.dat", package = "RavenR")
)
}
\arguments{
\item{rvp_file}{path to the model *.rvp file}

\item{rvp_outfile}{file path to rewritten rvp file}

\item{ost_outfile}{file path to Ostrich input file}

\item{params_calibration}{vector of parameters to include in the calibration}

\item{overwrite}{whether to overwrite an existing template file (default \code{FALSE})}

\item{RavenParamsFile}{path to RavenParameters.dat file (default path points to file included with RavenR installation)}
}
\value{
\code{TRUE} if the function executed successfully
}
\description{
Rewrites a Raven rvp file with placeholder parameter values.
}
\details{
Here, the rvp file is replaced with generic placeholder values to create a template file, which is commonly required for model calibration.
Although parameters may be found in other Raven input files, this command focuses on the rvp file. Other parameters
(such as gauge corrections in RVT or subbasin-level corrections in the RVH file) must be done manually.

The Raven rvp file may be generated from the \code{\link{rvn_rvp_fill_template}} function.

The list of parameters to be calibrated may be provided by the user (via \code{params_calibration} argument), or determined by RavenR. The intent of this
function is to provide a functional example of an RVP template file that may be used in calibration,
not a high quality calibration with clever selection of parameters to use. It is highly recommended
to build from the RVP template file created using expert hydrologic modelling knowledge.

If \code{rvp_outfile} is not provided, Raven will attempt to write to the file prefix of the provided template file with a .rvp.tpl extension.
If there is a conflict with an existing file and \code{overwrite==FALSE}, the function will automatically overwrite a file
with the suffix "_ravenr_generated.rvp.tpl".

Similarly with \code{ost_outfile}, the parameter default/min/max values and other Ostrich inputs will be written
based on a default template file to the ostIn.txt (or other provided file name). If this is set to NULL, the file will
not be written.

The default parameter values come from the RavenParameters.dat file included with RavenR in the extdata folder. The
user may provide their own file with updated values if preferred. Note that the database files held in the RavenR
package are unofficial copies of those in the official Raven SVN, and any discrepancies should defer to the Raven SVN versions.

Any parameters not found in this file will be ignored and a warning provided.

If you find parameters not found by this function, please open an ticket on Github (\url{https://github.com/rchlumsk/RavenR/issues}).
}
\examples{

# write rvp from template file
rvp_tempfile <- tempfile(fileext=".rvp")
rvn_rvp_fill_template(rvi_file=system.file("extdata","Nith.rvi", package="RavenR"),
                      rvh_file=system.file("extdata","Nith.rvh", package="RavenR"),
                      rvp_template_file =system.file("extdata","nithmodel.rvp_temp.rvp",
                      package="RavenR"),
                      rvp_out=rvp_tempfile)

# setup calibration rvp template and ostin file
ost_tempfile <- tempfile(fileext=".txt")
rvptpl_tempfile <- tempfile(fileext=".rvp.tpl")
rvn_rvp_calib_template(rvp_file=rvp_tempfile,
                       rvp_outfile=rvptpl_tempfile,
                       ost_outfile=ost_tempfile)

}
\seealso{
\code{\link{rvn_rvi_getparams}} to get parameter ranges from rvi.
}
