% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_write_Raven_label.R
\name{rvn_write_Raven_label}
\alias{rvn_write_Raven_label}
\title{Writes common Raven labeled line to file, with optional value (appends)}
\usage{
rvn_write_Raven_label(
  label,
  filename,
  value = NULL,
  digits = NULL,
  indent_level = 0
)
}
\arguments{
\item{label}{character, (e.g. "SoilClasses")}

\item{filename}{character, file name/path to write to, with extension}

\item{value}{numeric or character, corresponding value written after label (optional)}

\item{digits}{Number of digits to round value to (optional)}

\item{indent_level}{Adds two spaces before label for every one level (default = 0)}
}
\value{
\item{TRUE}{returns \code{TRUE} if executed successfully}
}
\description{
Writes common Raven labeled line to file, with optional value (appends)
}
\examples{

tf <- file.path(tempdir(), "Hogwarts.rvi")

# Numeric example
rvn_write_Raven_label('Duration', filename=tf, value=365)

# Hydrologic Processes
rvn_write_Raven_label('HydrologicProcesses', tf)

# String example, with indent
rvn_write_Raven_label('SnowBalance', filename = tf,
                      value = paste('SNOBAL_HMETS', 'MULTIPLE', 'MULTIPLE'),
                      indent_level = 1)

# Preview file
readLines(tf)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
